<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'shop';

    // Макс. ограничения
    $maxVideoSize     = 300 * 1024 * 1024; // 300 MB
    $maxVideoDuration = 180;               // 3 минуты в секундах

    function getVideoDurationSeconds(string $filePath): ?float
    {
        // ffprobe должен быть в PATH, иначе укажи полный путь
        $cmd = "ffprobe -v error -show_entries format=duration -of default=noprint_wrappers=1:nokey=1 " . escapeshellarg($filePath);
        $output = shell_exec($cmd);

        if ($output === null || $output === '') {
            return null; // не смогли определить длительность
        }

        return (float)$output;
    }


    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $resultC = $db_connect->select("shop_categories", "*") ?? [];
    foreach ($resultC as $row) {
        $categories[] = $row;
    }

    // Инициализация сообщения об ошибке
    $error_message = '';

    // Обработка формы добавления объявления
    if (isset($_POST['addshop'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("shops", "shop_id") + 1;

        // Подготовка запроса на добавление в таблицу coupons_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $shop_id = $p_id;
        if (!empty($_FILES['shop_images']['name'][0])) {
            $mainIndex = isset($_POST['is_main_image']) ? (int)$_POST['is_main_image'] : 0;

            require_once ENGINE_DIR."/mods/compress_images.php";

            foreach ($_FILES['shop_images']['name'] as $i => $originalName) {

                // Проверка ошибок
                if ($_FILES['shop_images']['error'][$i] !== UPLOAD_ERR_OK) continue;

                $tmp_name = $_FILES['shop_images']['tmp_name'][$i];

                if (!is_uploaded_file($tmp_name)) continue;

                $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
                $filename = time() . "_" . rand(1000, 9999) . "." . $ext;

                $uploadDir = $_SERVER["DOCUMENT_ROOT"] . "/uploads/images/shops/shop/" . $shop_id . "/";
                if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
                if (!is_writable($uploadDir)) continue;

                $fullPath = $uploadDir . $filename;

                // Если уже WebP — просто перемещаем
                if ($ext === 'webp') {
                    move_uploaded_file($tmp_name, $fullPath);
                    $webpFilename = $filename;
                } else {
                    // Перемещаем исходник
                    move_uploaded_file($tmp_name, $fullPath);

                    // Конвертируем в WebP
                    $webpFilename = preg_replace('/\.(jpe?g|png|gif)$/i', '.webp', $filename);
                    $webpFullPath = $uploadDir . $webpFilename;
                    autoOptimizeWebP($fullPath, $webpFullPath, 1200, 0); // ширина 1200px

                    // Удаляем исходный файл
                    @unlink($fullPath);
                }

                // Флаг главного фото
                $isMain = ($i === $mainIndex) ? 1 : 0;

                // Сохраняем путь в БД
                $db_connect->insert("shop_product_files", [
                    "shop_id" => $shop_id,
                    "url" => "/uploads/images/shops/shop/$shop_id/".$webpFilename,
                    "is_main" => $isMain,
                    "file_type" => "image"
                ]);
            }

            // ----------------- ВИДЕО -----------------
            if (!empty($_FILES['shop_videos']) && !empty($_FILES['shop_videos']['name'][0])) {
                foreach ($_FILES['shop_videos']['name'] as $i => $originalName) {

                    // Ошибка загрузки
                    if ($_FILES['shop_videos']['error'][$i] !== UPLOAD_ERR_OK) {
                        continue;
                    }

                    $tmp_name = $_FILES['shop_videos']['tmp_name'][$i];

                    if (!is_uploaded_file($tmp_name)) {
                        continue;
                    }

                    // 1) ПРОВЕРКА РАЗМЕРА (<= 300MB)
                    $size = (int)$_FILES['shop_videos']['size'][$i];
                    if ($size > $maxVideoSize) {
                        // Можно записать ошибку в лог / показать сообщение
                        // например: "Видео превышает 300MB"
                        continue;
                    }

                    // 2) ПРОВЕРКА ТИПА ФАЙЛА (расширение + MIME по-хорошему)
                    $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
                    $allowedExt = ['mp4','mov','webm','avi','mkv'];

                    if (!in_array($ext, $allowedExt, true)) {
                        continue;
                    }

                    // 4) Сохранение файла
                    $filename  = time() . "_" . rand(1000, 9999) . "." . $ext;
                    $uploadDir = $_SERVER["DOCUMENT_ROOT"] . "/uploads/videos/shops/shop/" . $shop_id . "/";

                    if (!is_dir($uploadDir)) {
                        mkdir($uploadDir, 0777, true);
                    }

                    if (!is_writable($uploadDir)) {
                        continue;
                    }

                    $fullPath = $uploadDir . $filename;

                    if (!move_uploaded_file($tmp_name, $fullPath)) {
                        continue;
                    }

                    // 5) Запись в БД
                    // Если у тебя отдельная таблица для видео – поменяй название.
                    // Если всё хранится в той же shop_product_files, можно пометить как видео через отдельное поле, если оно есть.
                    $db_connect->insert("shop_product_files", [
                        "shop_id" => $shop_id,
                        "url"     => "/uploads/videos/shops/shop/$shop_id/" . $filename,
                        "is_main" => 0,
                        "file_type" => "video"
                    ]);
                }
            }

        }



        $result = $db_connect->insert("shops", [
            "owner_id" => $_SESSION['user_id'],
            "shop_name" => $_POST['shop_name'],
            "slug" => $_POST['slug'],
            "description" => $_POST['description'],
            "lat" => $_POST["location_lat"],
            "lng" => $_POST["location_lng"],
            "location" => $_POST["location_address"],
        ]);

    }


    $shop_id = $db_connect->id();

    if (!empty($_POST["category"])) {
        foreach ($_POST["category"] as $categoryId) {
            $db_connect->insert("shop_cat_relations", [
                "shop_id" => (int)$shop_id,
                "category_id" => (int)$categoryId,
            ]);
        }
    }

    require_once ENGINE_DIR . '/mods/access_control.php';
    saveAccessSettings((int)$shop_id, "shops", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

    if (!empty($field_ids)) {
        foreach ($field_ids as $field_id) {
            if (!empty($_POST['x_value'][$field_id])) {
                $insertField = $db_connect->insert("shop_field_values", [
                    "shop_id" => $shop_id,
                    "field_id" => $field_id,
                    "x_value" => $_POST['x_value'][$field_id]
                ]);
            }
        }
    }
    // Проверяем результат выполнения запроса
    if ($result) {
        // Перенаправление на ту же страницу после добавления
        header("Location: /admin?action=modules/shops/list");
        exit();
    } else {
        $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    // Закрываем соединение с базой данных
    $lastRow = $db_connect->get("shops", ['shop_id'], [
        "ORDER" => ["shop_id" => "DESC"] // Сортировка по убыванию id
    ]);
    $smarty->assign('POST', $_POST);
    $_POST = [];
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addshop'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active"><a href="/admin?action=modules/shops/list">Объявления</a></li>
            <li class="breadcrumb-item active">' . $lang['nav']['addshop'] . '</li>
        ');
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', ""); //todo: ??