<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'shop';

    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $resultC = $db_connect->select("shop_categories", "*") ?? [];
    foreach ($resultC as $row) {
        $categories[] = $row;
    }

    // Инициализация сообщения об ошибке
    $error_message = '';

    $shop = $db_connect->get("shops", "*", ["shop_id" => $_GET['shop_id']]);

    // Обработка формы добавления объявления
    if (isset($_POST['add_shop_product'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = $_GET["shop_id"];

        // Подготовка запроса на добавление в таблицу coupons_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $shop_id = $p_id;

        $result = $db_connect->insert("shop_products", [
            "shop_id" => $shop_id,
            "name" => $_POST['name'] ?? '',
            "slug" => $_POST['slug'] ?? '',
            "price" => $_POST['price'] ?? '',
            "stock" => $_POST['stock'] ?? '',
            "is_active" => $_POST['is_active'] ?? 0,
            "description" => $_POST['description'] ?? '',
            "article" => generateSKU()
        ]);

        $product_id = $db_connect->id();

        if (!empty($_POST['attributes'])) {
            foreach ($_POST['attributes'] as $attr) {
                $db_connect->insert("shop_product_attributes", [
                    "product_id" => $product_id,
                    "name" => $attr['name'],
                    "value" => $attr['value']
                ]);
            }
        }


        if (!empty($_POST["category"])) {
            foreach ($_POST["category"] as $categoryId) {
                $db_connect->insert("shop_cat_relations", [
                    "product_id" => (int)$product_id,
                    "category_id" => (int)$categoryId,
                ]);
            }
        }
        require_once ENGINE_DIR."/mods/compress_images.php";

        // ===== ОБРАБОТКА ИЗОБРАЖЕНИЙ =====
        if (!empty($_FILES['images']['name'][0])) {
            foreach ($_FILES['images']['name'] as $i => $originalName) {

                $errorCode = $_FILES['images']['error'][$i];
                if ($errorCode !== UPLOAD_ERR_OK) {
                    echo "Ошибка загрузки файла $originalName: $errorCode\n";
                    continue;
                }

                $tmp_name = $_FILES['images']['tmp_name'][$i];

                if (!is_uploaded_file($tmp_name)) {
                    echo "Файл $originalName не распознан как загруженный\n";
                    continue;
                }

                $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
                $filename = time() . "_" . rand(1000,9999) . "." . $ext;

                $uploadDir = $_SERVER["DOCUMENT_ROOT"] . "/uploads/images/shops/" . $product_id . "/";
                if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
                if (!is_writable($uploadDir)) {
                    echo "Папка $uploadDir недоступна для записи!\n";
                    continue;
                }

                $fullPath = $uploadDir . $filename;

                // Если уже WebP — просто перемещаем
                if ($ext === 'webp') {
                    if (!move_uploaded_file($tmp_name, $fullPath)) {
                        echo "Не удалось переместить WebP файл $originalName\n";
                        var_dump(error_get_last());
                        continue;
                    }
                    $webpFilename = $filename;
                } else {
                    // Перемещаем исходник
                    if (!move_uploaded_file($tmp_name, $fullPath)) {
                        echo "Не удалось переместить файл $originalName\n";
                        var_dump(error_get_last());
                        continue;
                    }

                    // Конвертируем в WebP
                    $webpFilename = preg_replace('/\.(jpe?g|png|gif)$/i', '.webp', $filename);
                    $webpFullPath = $uploadDir . $webpFilename;
                    autoOptimizeWebP($fullPath, $webpFullPath, 1200, 0); // ширина 1200px

                    // Удаляем исходник
                    @unlink($fullPath);
                }

                // Сохраняем путь в БД
                $db_connect->insert("shop_product_files", [
                    "product_id" => $product_id,
                    "url" => "/uploads/images/shops/$product_id/".$webpFilename,
                ]);
            }
        }




    }


    // Проверяем результат выполнения запроса
    if ($result) {
        // Перенаправление на ту же страницу после добавления
        header("Location: /shops/{$shop['slug']}");
        exit();
    } else {
        $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
    }

    function generateSKU() {
        $letter = chr(random_int(65, 90));
        $numbers = str_pad((string)random_int(0, 9999999), 7, '0', STR_PAD_LEFT);
        return $letter . $numbers;
    }


    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    // Закрываем соединение с базой данных
    $lastRow = $db_connect->get("shops", ['shop_id'], [
        "ORDER" => ["shop_id" => "DESC"] // Сортировка по убыванию id
    ]);
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => "Добавление товара магазина" . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active"><a href="/admin?action=modules/shops/list">Онлайн магазины</a></li>
            <li class="breadcrumb-item active">' . $lang['nav']['addshop'] . '</li>
        ');
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('shop', $shop);
    $smarty->assign('error_message', ""); //todo: ??