<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        $db_connect->delete("shops", ["shop_id" => $page_id]);
        
        header("Location: /admin?action=modules/shops/list");
        exit();
    }

    $shopProducts = $db_connect->select('shop_products', '*', ["shop_id" => $_GET["shop_id"]]);
    $shop = $db_connect->get("shops", "*", ["shop_id" => $_GET["shop_id"]]);

    $categoriesAltNames = [];
    $categories = $db_connect->select('shop_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });

    require_once ENGINE_DIR . '/mods/get_module_categories.php';
    foreach ($shopProducts as $key => &$ad) {
        $ad["uniq_id"] = $key+1;
        $ad['category'] = getCategoriesString($ad['shop_id'], "shop");
        $ad['category_names'] = $categories;
        $ad["name"] = "<a target='_blank' href='/shopProduct/?product_id={$ad['id']}'>" . $ad["name"] . "</a>";
        $ad["lang"] = "<img src='/engine/lang/{$ad['language']}/icon.png' style='height: 22px;' alt=''>";
        $ad["actions"] = "<a href='/admin?action=modules/shops/edit_product&product_id={$ad['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                    <form method='POST' action='/admin?action=modules/shops/list' style='display:inline;'>
                                        <input type='hidden' name='delete_page_id' value='{$ad['id']}'>
                                        <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить этот магазин?`);'>
                                            <i class='fa fa-trash'></i>
                                        </button>
                                    </form>";
    }

    $smarty->assign('shop', $shop);
    $smarty->assign('shopProducts', $shopProducts);
    $yourData = array('title' => 'Все товары магазина ' . $shop["shop_name"] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
                 <li class="breadcrumb-item"><a href="/admin?action=modules/shops/list">Онлайн магазины</a></li>
                <li class="breadcrumb-item active">' . 'Все товары магазина ' . $shop["shop_name"] . '</li>
            ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);