<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Обработка удаления участника
        if (isset($_POST['delete_participants_id'])) {
            $participants_id = intval($_POST['delete_participants_id']);
            $stmt = $db_connect->prepare("DELETE FROM lots_participants WHERE id = ?");
            $stmt->bind_param('i', $participants_id);
            $stmt->execute();
            $stmt->close();
    
            // Перенаправление на текущую страницу для обновления списка заявок
            header("Location: " . $_SERVER['REQUEST_URI']);
            exit();
        }
    
        // Обработка обновления данных участника
        if (isset($_POST['participant_id'])) {
            $participant_id = intval($_POST['participant_id']);
            $username = isset($_POST['username']) ? mysqli_real_escape_string($db_connect, $_POST['username']) : '';
            $phone = isset($_POST['phone']) ? mysqli_real_escape_string($db_connect, $_POST['phone']) : '';
            $social_url = isset($_POST['social_url']) ? mysqli_real_escape_string($db_connect, $_POST['social_url']) : '';
            $status = isset($_POST['status']) ? mysqli_real_escape_string($db_connect, $_POST['status']) : '';
            $notes = isset($_POST['notes']) ? mysqli_real_escape_string($db_connect, $_POST['notes']) : '';
            $lots_title = isset($_POST['lots_title']) ? mysqli_real_escape_string($db_connect, $_POST['lots_title']) : '';
    
            // Проверка корректности данных
            if ($participant_id > 0 && !empty($username) && !empty($phone)) {
                // SQL-запрос для обновления данных участника
                $query = "UPDATE lots_participants SET username = ?, phone = ?, social_url = ?, status = ?, notes = ?, lots_title = ? WHERE id = ?";
                $stmt = $db_connect->prepare($query);
                $stmt->bind_param('ssssssi', $username, $phone, $social_url, $status, $notes, $lots_title, $participant_id);
                if ($stmt->execute()) {
                    // Перенаправление на текущую страницу для обновления списка заявок
                    header("Location: " . $_SERVER['REQUEST_URI']);
                    exit();
                } else {
                    echo 'Ошибка: ' . $stmt->error;
                }
                $stmt->close();
            } else {
                echo 'Некорректные данные участника.';
            }
        }
    }

    // SQL запрос для извлечения заявок, отсортированных по дате создания (новые вверху)
    $sql = "SELECT * FROM lots_participants ORDER BY registration_date DESC";
    $result = $db_connect->query($sql);
    // Проверка наличия данных
    if ($result->num_rows > 0) {
        // Создание массива для хранения заявок
        $lots_participants = array();
        // Чтение результатов выборки
        while ($row = $result->fetch_assoc()) {
            // Добавление каждой заявки в массив
            $lots_participants[] = $row;
        }
    } else {
        // Если заявок нет, можно установить сообщение об отсутствии данных
        $lots_participants = array(); // Пустой массив, если нет заявок
    }
    $smarty->assign('lots_participants', $lots_participants);

    $yourData = array('title' => $lang['nav']['participantsrequests'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=lots/list">' . $lang['topmenu']['lots'] . '</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['lotsparticipants'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);