<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

// Путь к config.php относительно текущего файла
require_once(ENGINE_DIR . '/data/config.php');

// Проверка, была ли отправлена форма для удаления страницы
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
    $page_id = $_POST['delete_page_id'];

    // Выполняем запрос для удаления страницы с использованием Medoo
    $result = $db_connect->delete('static_pages', [
        'id' => $page_id
    ]);

    if ($result->rowCount() > 0) {
        // Успешно удалена страница
        header("Location: /admin?action=pages");
        exit();
    } else {
        die("Ошибка удаления страницы или страница не найдена.");
    }
}

// Выполняем запрос для получения полного списка страниц с использованием Medoo
$rows = $db_connect->select('static_pages', '*');
$smarty->registerPlugin('modifier', 'json_encode', function($value) {
    return json_encode($value);
});
// Формируем данные для отображения
foreach ($rows as &$row) {
    $row[$lang["datatable"]["date"]] = $row["date"];
    $row[$lang["datatable"]["views"]] = $row["views"];
    $row[$lang["datatable"]["title"]] = "<a target='_blank' href='{$row['alt_name']}?lang={$row['language']}'>" . htmlspecialchars($row["title"]) . "</a>";
    $row[$lang["datatable"]["lang"]] = "<img src='/engine/lang/{$row['language']}/icon.png' style='height: 22px;' alt=''>";
    $row[$lang["datatable"]["actions"]] = "<a href='/admin?action=page_edit&id={$row['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                            <form method='POST' action='/admin?action=pages' style='display:inline;'>
                                <input type='hidden' name='delete_page_id' value='{$row['id']}'>
                                <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить эту страницу?`);'>
                                    <i class='fa fa-trash'></i>
                                </button>
                            </form>";
}

// Устанавливаем массив переменных в Smarty
$smarty->assign('rows', $rows);
$yourData = array('title' => $lang['nav']['pageslist'] . ' - ' . $config['title']);
$smarty->assign('data', $yourData);
$smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['pageslist'] . '</li>
    ');
$smarty->assign('theme', SYSTEM_DIR);
$smarty->assign('config', $config);
?>
