<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Путь к файлу конфигурации
    $config_file_path = ENGINE_DIR . '/payment/systems/general_config.php';

    // Загрузка содержимого файла
    function load_config_file($file_path) {
        return file_exists($file_path) ? file_get_contents($file_path) : '';
    }

    // Сохранение содержимого файла
    function save_config_file($file_path, $content) {
        file_put_contents($file_path, $content);
    }

    // Обработка формы
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $config_content = $_POST['config_content'] ?? '';
        if (!empty($config_content)) {
            save_config_file($config_file_path, $config_content);
            header('Location: /admin?action=payment-systems');
            exit();
        } else {
            $error_message = 'Configuration content cannot be empty.';
        }
    }

    // Загрузка текущего содержимого конфигурационного файла
    $config_content = load_config_file($config_file_path);

    // Передача данных в Smarty
    $ps_title = $lang['megamenu']['paymentsystems'] ?? 'Payment Systems';
    $ps_config_title = $config['title'] ?? 'Default Title';
    // Устанавливаем заголовки страницы
    $yourData = array('title' => $lang['megamenu']['paymentsystems'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['paymentsystems'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('configContent', $config_content);