<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Обработка формы
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $file = isset($_POST['file']) ? $_POST['file'] : null;
        $content = isset($_POST['content']) ? $_POST['content'] : null;
        $activeTab = isset($_POST['active_tab']) ? $_POST['active_tab'] : 'cookies'; // Получаем текущий активный таб
        
        if ($file && $content) {
            $filePath = ENGINE_DIR . '/lang/' . $lang_code . "/" . $file . '.tpl';
            file_put_contents($filePath, $content);
            $message = 'Файл успешно сохранен.';
        } else {
            $message = 'Ошибка при сохранении файла.';
        }

        // Редирект с учетом активного таба
        header('Location: /admin?action=policy-terms-cookies&tab=' . urlencode($activeTab));
        exit();
    }

    // Загрузка содержимого файлов
    function loadFilesData($lang_code) {
        global $smarty, $config;
        // Формируем пути к файлам на основе выбранного языка
        $cookiePath = ENGINE_DIR . "/lang/$lang_code/cookies.tpl";
        $policyPath = ENGINE_DIR . "/lang/$lang_code/policy.tpl";
        $termsPath = ENGINE_DIR . "/lang/$lang_code/terms.tpl";
        // Чтение содержимого файлов
        if (file_exists($cookiePath) && file_exists($policyPath) && file_exists($termsPath)) {
            // Если файлы существуют, загружаем их
            $cookieContent = file_get_contents($cookiePath);
            $policyContent = file_get_contents($policyPath);
            $termsContent = file_get_contents($termsPath);
        } else {
            // Если файлы не найдены, используем язык по умолчанию из $config['default_lang']
            $defaultLang = $config['default_lang'];
            $cookieContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/cookies.tpl");
            $policyContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/policy.tpl");
            $termsContent = file_get_contents(ENGINE_DIR . "/lang/$defaultLang/terms.tpl");
        }
        // Присвоение значений глобальным переменным Smarty
        $smarty->assign('cookieContent', $cookieContent);
        $smarty->assign('policyContent', $policyContent);
        $smarty->assign('termsContent', $termsContent);
        // Присвоение $config глобальной переменной Smarty
        $smarty->assign('config', $config);
    }
    // Пример вызова функции
    loadFilesData($lang_code);

    $yourData = array('title' => $lang['nav']['policytermscookies'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['policytermscookies'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);

    // Устанавливаем активный таб на основе GET-параметра или по умолчанию
    $activeTab = isset($_GET['tab']) ? $_GET['tab'] : 'cookies';
    $smarty->assign('activeTab', $activeTab);