<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    date_default_timezone_set('UTC');
    require_once ENGINE_DIR.'/mods/banned_words_detector.php';

    global $db_connect, $config, $lang;

    if (!isset($_SESSION['punishment_logs_form_key'])) {
        $_SESSION['punishment_logs_form_key'] = uniqid();
    }

    if (!empty($_POST["form_key"]) && $_POST['form_key'] == $_SESSION['punishment_logs_form_key']) {

        if (isset($_POST["ban_user"]) && !empty($_POST["punishment_type"]) && !empty($_POST["pl_id"])) {

            banUserCommenting($_POST["pl_id"], $_POST["punishment_type"]);

        }
        header("Location: ".$_SERVER["HTTP_REFERER"]);

    }

    $punishmentLogs = $db_connect->select("punishment_logs", "*", [
        "ORDER" => ["id" => "DESC"],
    ]);

    $punishmentTypes = $db_connect->select("punishment_types", "*");

    foreach ($punishmentLogs as $key => &$punishmentLog) {

        $comment = $db_connect->get("comments", "comment_text", [
            "id" => (int)$punishmentLog["comment_id"],
        ]);

        $userEmail = "Guest";
        if (!empty($punishmentLog["user_id"])) {
            $userEmail = $db_connect->get("users", "email", [
                "id" => (int)$punishmentLog["user_id"],
            ]);
        }

        $userPunishment = [];
        if (!empty($punishmentLog["punishment_id"])) {
            $userPunishment = $db_connect->get("user_punishments", "*", [
                "id" => (int)$punishmentLog["punishment_id"]
            ]);
        }


        $banned = false;
        if (!checkIsAccessComment()) {
            $banned = true;
            $punishmentLog[$lang['datatable']['status']] = "Забанен до: ". $userPunishment["expires_at"];
        } else {
            $punishmentLog[$lang['datatable']['status']] = "Не забанен";
        }

        $punishmentLog[$lang['datatable']['uniq_id']] = $key+1;

        $punishmentLog[$lang['datatable']['email']] = $userEmail;
        $punishmentLog[$lang['datatable']['ip_address']] = $punishmentLog['ip_address'];
        $punishmentLog[$lang['datatable']['comment']] = $comment ?? "";

        $punishmentLog[$lang['datatable']['banned_word']] = $punishmentLog['banned_word'];
        $punishmentLog[$lang['datatable']['created_at']] = $punishmentLog['created_at'];

        if ($banned) {
            $punishmentLog[$lang['datatable']['actions']] = "
                <a href='#' class='mx-1 top-1 unban-user' data-id='{$punishmentLog["id"]}'><i class='fa fa-unlock'></i> Разблокировать</a>
                ";
        } else {
            $punishmentLog[$lang['datatable']['actions']] = "
                <a href='#' class='mx-1 top-1 ban-user' data-id='{$punishmentLog["id"]}'><i class='fa fa-ban'></i> Блокировка</a>
                ";
        }


    }


    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $yourData = array('title' => $lang['nav']['punishmentlogs'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('punishmentTypes', $punishmentTypes);
    $smarty->assign('punishmentLogs', $punishmentLogs);
    $smarty->assign('form_key', $_SESSION['punishment_logs_form_key']);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['punishmentlogs'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);