<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');


    global $db_connect; // если используешь Medoo, подключи $db

    // Получаем все запросы на возврат
    $refundRequests = $db_connect->select('refund_requests', '*', [
        "ORDER" => ["requested_at" => "DESC"]
    ]);

    // Превращаем в удобный формат для шаблона
    foreach($refundRequests as $key => &$req){
        $req["uniq_id"] = $key+1;

        $transaction = $db_connect->get("transactions", "*", ["id" => $req["transaction_id"]]);

        $req["transaction_id"] = $transaction["transaction_id"];
        $req["user_email"] = $db_connect->get("users", "email", ["id" => $req["user_id"]]);
        $req["sum"] = $transaction["sum"]." ".$transaction["currency"];

        $req['status_label'] = match($req['status']){
            'pending' => '<span class="badge bg-warning">В ожидании</span>',
            'approved' => '<span class="badge bg-success">Одобрено</span>',
            'rejected' => '<span class="badge bg-danger">Отклонено</span>',
        };
    }
    unset($req);

    $smarty->assign('refundRequests', $refundRequests);
    $yourData = array('title' => $lang['nav']['eventlog'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['eventlog'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);