<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

// Путь к config.php относительно текущего файла
require_once(ENGINE_DIR . '/data/config.php');
require_once(ENGINE_DIR . '/mods/database_helper.php');

if (isset($_POST["create_reg_field"])) {

    if (!empty($_POST["selected_role"]) && !empty($_POST["type"]) && !empty($_POST["name"])) {

        $groupId = $db_connect->get("roles", "id", ["name" => $_POST["selected_role"]]);

        if (!empty($groupId)) {
            $db_connect->insert("registration_custom_fields", [
                "name" => $_POST["name"],
                "type" => $_POST["type"],
                "group_id" => $groupId,
            ]);
        }

    }


    header("Location: ".$_SERVER["HTTP_REFERER"]);
}

// Получаем список промокодов
$registrationCustomFields = $db_connect->select("registration_custom_fields", "*", [
    'ORDER' => ['id' => 'DESC']
]);

if (!isset($_SESSION['category_form_key'])) {
    $_SESSION['category_form_key'] = uniqid();
}

$fromGroupsData = [];
$groups = [];

foreach ($config["default_roles"] as $key => $group) {
    if ($key != "roles_from_confirm") {
        $fromGroupsData[$key] = [];
        $gGroup = $db_connect->get("roles", "*", ["name" => $key]);
        if (!empty($gGroup)) {
            $groups[] = $gGroup;
        } else {
            $currentPerms = [];
            if (!empty($config["default_roles"][$key])) {
                foreach ($config["default_roles"][$key] as $ikey => $value) {
                    $currentPerms[$value] = true;
                }
            }

            $fromConfirmGroupId = $db_connect->max("roles", "id") + 1;

            $data = [
                "id" => $fromConfirmGroupId,
                "name" => $key,
            ];
           // $data = array_merge($data, $currentPerms);

            $db_connect->insert("roles", $data);

            $gGroup = $db_connect->get("roles", "*", ["name" => $key]);
            $groups[] = $gGroup;
        }
    }
}

foreach ($registrationCustomFields as $key => &$registrationCustomField) {
    $registrationCustomField["group"] = $db_connect->get("roles", "name", ["id" => $registrationCustomField["group_id"]]);

    $registrationCustomField["current_id"] = $registrationCustomField["id"];
    $registrationCustomField["id"] = count($fromGroupsData[$registrationCustomField["group"]]) + 1;
    $userApplication["actions"] = "";

    $registrationCustomField[$lang["datatable"]["name"]] = $registrationCustomField["name"];
    $registrationCustomField[$lang["datatable"]["options"]] = $registrationCustomField["options"];
    $registrationCustomField[$lang["datatable"]["type"]] = $registrationCustomField["type"];
    $registrationCustomField[$lang["datatable"]["required"]] = $registrationCustomField["required"];
    $registrationCustomField[$lang["datatable"]["created_at"]] = $registrationCustomField["created_at"];

    $fromGroupsData[$registrationCustomField["group"]][] = $registrationCustomField;
}


$smarty->registerPlugin('modifier', 'json_encode', function($value) {
    return json_encode($value);
});
// Устанавливаем массив переменных в Smarty
$yourData = array('title' => $lang['megamenu']['regcustomfields'] . ' - ' . $config['title']);
$smarty->assign("fromGroupsData", $fromGroupsData);
$smarty->assign("groups", $groups);
$smarty->assign('data', $yourData);
$smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['regcustomfields'] . '</li>
    ');
$smarty->assign('form_key', $_SESSION['category_form_key']);
$yourData = array('title' => $lang['megamenu']['regcustomfields'] . ' - ' . $config['title']);
$smarty->assign('theme', SYSTEM_DIR);
$smarty->assign('config', $config);
?>
