<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect;

    $roles = $db_connect->select("roles", "*");

    foreach ($roles as &$role) {

        $role["actions"] = "<a href='#' id='edit-ico' class='mx-3 fa fa-edit edit-ico' data-id='{$role['id']}'></a>
                            <a href='#' id='delete-ico' class='mx-3 fa fa-trash delete-ico' data-id='{$role['id']}'></a>";

    }
    unset($role);


    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign("roles", $roles);
    $yourData = array('title' => 'Все роли' . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . 'Все роли' . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);