<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    $configFilePath = ENGINE_DIR . '/data/config.php';
    require_once($configFilePath);
    require_once(ENGINE_DIR . '/tools/check_timezones.php');

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['form_type']) && $_POST['form_type'] === 'settings_save') {
            // Обновление массива конфигурации значениями из формы
            $config['title'] = $_POST['title'];
            $config['feedback_mail'] = $_POST['feedback_mail'];
            $config['default_timezone'] = $_POST['default_timezone'];
            $config['skin'] = $_POST['skin'];
            $config['default_lang'] = $_POST['default_lang'];
            $config['site_offline'] = isset($_POST['site_offline']) && $_POST['site_offline'] === 'true' ? true : false;
            $config['home_tpl'] = isset($_POST['home_tpl']) && $_POST['home_tpl'] === 'true' ? true : false;
            $config['lang_union'] = isset($_POST['lang_union']) && $_POST['lang_union'] === 'true' ? true : false;
            $config['payment_info']['show_all_currencies'] = isset($_POST['show_all_currencies']) && $_POST['show_all_currencies'] === 'true' ? true : false;
            $config['description'] = $_POST['description'];
            $config['keywords'] = $_POST['keywords'];
            $config['database_settings']['enabled_database'] = $_POST['db_type'] ?? 'mysql';

            if (!empty($_POST['referral_reward_percentage']) && empty($_POST['referral_fix_sum'])) {
                $config['referral_reward_percentage'] = $_POST['referral_reward_percentage'];
                $config['referral_fix_sum'] = "";
            } elseif (!empty($_POST['referral_fix_sum']) && empty($_POST['referral_reward_percentage'])) {
                $config['referral_fix_sum'] = $_POST['referral_fix_sum'];
                $config['referral_reward_percentage'] = "";
            } else {
                die("Ошибка: Укажите только одно из полей (referral_reward_percentage или referral_fix_sum).");
            }

            $config['payment_info']['included_currencies'] = explode(" ", $_POST["included_currencies"]);
            unlink(ENGINE_DIR.'/data/exchange_rates.json');

            if (!empty($_POST["emailTemplates"])) {
                foreach ($_POST["emailTemplates"] as $category => $emailTemplate) {
                    foreach ($config['email_template_settings'][$category] as $key => $value) {
                        $config['email_template_settings'][$category][$key] = false;
                    }
                    $config['email_template_settings'][$category][$emailTemplate] = true;
                }
            }

            if (!empty($_POST["email_settings"])) {
                foreach ($_POST["email_settings"] as $name => $value) {
                    $config["email_settings"][$name] = $value;
                }
            }

            if (!empty($_POST["payment_settings"])) {
                foreach ($_POST["payment_settings"] as $name => $value) {
                    $config["payment_info"][$name] = $value;
                }
            }

            if (!empty($_POST["enabled_captcha"])) {
                $config["captcha_settings"]["enabled_captcha"] = $_POST["enabled_captcha"];
            }

            // Обновление конфигурации объявлений
            if (isset($config['modules']['ads']) && $config['modules']['ads']['used'] === true) {
                if (!empty($_POST['ads_per_page'])) {
                    $config['modules']['ads']['ads_per_page'] = $_POST['ads_per_page'];
                }
                if (!empty($_POST['ads_fromcats_per_page'])) {
                    $config['modules']['ads']['ads_fromcats_per_page'] = $_POST['ads_fromcats_per_page'];
                }
                if (!empty($_POST['ads_comments_limit'])) {
                    $config['modules']['ads']['comments_limit'] = $_POST['ads_comments_limit'];
                }
                if (!empty($_POST['ads_short_tpl'])) {
                    $config['modules']['ads']['short_tpl'] = $_POST['ads_short_tpl'];
                }
                if (!empty($_POST['ads_full_tpl'])) {
                    $config['modules']['ads']['full_tpl'] = $_POST['ads_full_tpl'];
                }
                $config['modules']['ads']['filter_form'] = $_POST['ads_module_filter'] == 'true';
            }

            // Обновление конфигурации файлов
            if (isset($config['modules']['files']) && $config['modules']['files']['used'] === true) {
                if (!empty($_POST['files_per_page'])) {
                    $config['modules']['files']['files_per_page'] = $_POST['files_per_page'];
                }
                if (!empty($_POST['files_fromcats_per_page'])) {
                    $config['modules']['files']['files_fromcats_per_page'] = $_POST['files_fromcats_per_page'];
                }
                if (!empty($_POST['files_comments_limit'])) {
                    $config['modules']['files']['comments_limit'] = $_POST['files_comments_limit'];
                }
                if (!empty($_POST['files_short_tpl'])) {
                    $config['modules']['files']['short_tpl'] = $_POST['files_short_tpl'];
                }
                if (!empty($_POST['files_full_tpl'])) {
                    $config['modules']['files']['full_tpl'] = $_POST['files_full_tpl'];
                }
                $config['modules']['files']['filter_form'] = $_POST['files_module_filter'] == 'true';

            }

            // Обновление конфигурации фильмов
            if (isset($config['modules']['movies']) && $config['modules']['movies']['used'] === true) {
                if (!empty($_POST['movies_per_page'])) {
                    $config['modules']['movies']['movies_per_page'] = $_POST['movies_per_page'];
                }
                if (!empty($_POST['movies_fromcats_per_page'])) {
                    $config['modules']['movies']['movies_fromcats_per_page'] = $_POST['movies_fromcats_per_page'];
                }
                if (!empty($_POST['movies_comments_limit'])) {
                    $config['modules']['movies']['comments_limit'] = $_POST['movies_comments_limit'];
                }
                if (!empty($_POST['movies_short_tpl'])) {
                    $config['modules']['movies']['short_tpl'] = $_POST['movies_short_tpl'];
                }
                if (!empty($_POST['movies_full_tpl'])) {
                    $config['modules']['movies']['full_tpl'] = $_POST['movies_full_tpl'];
                }
                $config['modules']['movies']['filter_form'] = $_POST['movies_module_filter'] == 'true';
            }

            // Обновление конфигурации новостей
            if (isset($config['modules']['news']) && $config['modules']['news']['used'] === true) {
                if (!empty($_POST['news_per_page'])) {
                    $config['modules']['news']['news_per_page'] = $_POST['news_per_page'];
                }
                if (!empty($_POST['news_fromcats_per_page'])) {
                    $config['modules']['news']['news_fromcats_per_page'] = $_POST['news_fromcats_per_page'];
                }
                if (!empty($_POST['news_comments_limit'])) {
                    $config['modules']['news']['comments_limit'] = $_POST['news_comments_limit'];
                }
                if (!empty($_POST['news_short_tpl'])) {
                    $config['modules']['news']['short_tpl'] = $_POST['news_short_tpl'];
                }
                if (!empty($_POST['news_full_tpl'])) {
                    $config['modules']['news']['full_tpl'] = $_POST['news_full_tpl'];
                }
                $config['modules']['news']['filter_form'] = $_POST['news_module_filter'] == 'true';
            }

            // Обновление конфигурации товаров
            if (isset($config['modules']['products']) && $config['modules']['products']['used'] === true) {
                if (!empty($_POST['products_per_page'])) {
                    $config['modules']['products']['products_per_page'] = $_POST['products_per_page'];
                }
                if (!empty($_POST['products_fromcats_per_page'])) {
                    $config['modules']['products']['products_fromcats_per_page'] = $_POST['products_fromcats_per_page'];
                }
                if (!empty($_POST['products_comments_limit'])) {
                    $config['modules']['products']['comments_limit'] = $_POST['products_comments_limit'];
                }
                if (!empty($_POST['products_short_tpl'])) {
                    $config['modules']['products']['short_tpl'] = $_POST['products_short_tpl'];
                }
                if (!empty($_POST['products_full_tpl'])) {
                    $config['modules']['products']['full_tpl'] = $_POST['products_full_tpl'];
                }
                if (!empty($_POST['default_currency'])) {
                    $config['modules']['products']['default_currency'] = $_POST['default_currency'];
                }
                $config['modules']['products']['filter_form'] = $_POST['products_module_filter'] == 'true';

            }

            if (isset($config['modules']['events']) && $config['modules']['events']['used'] === true) {
                if (!empty($_POST['events_per_page'])) {
                    $config['modules']['events']['products_per_page'] = $_POST['products_per_page'];
                }
                if (!empty($_POST['events_fromcats_per_page'])) {
                    $config['modules']['events']['events_fromcats_per_page'] = $_POST['events_fromcats_per_page'];
                }
                if (!empty($_POST['events_comments_limit'])) {
                    $config['modules']['events']['comments_limit'] = $_POST['events_comments_limit'];
                }
                if (!empty($_POST['events_short_tpl'])) {
                    $config['modules']['events']['short_tpl'] = $_POST['events_short_tpl'];
                }
                if (!empty($_POST['events_full_tpl'])) {
                    $config['modules']['events']['full_tpl'] = $_POST['events_full_tpl'];
                }
                if (!empty($_POST['default_currency'])) {
                    $config['modules']['events']['default_currency'] = $_POST['default_currency'];
                }
                $config['modules']['events']['filter_form'] = $_POST['events_module_filter'] == 'true';

            }

            if (isset($config['modules']['lots']) && $config['modules']['lots']['used'] === true) {
                if (!empty($_POST['lots_per_page'])) {
                    $config['modules']['lots']['products_per_page'] = $_POST['products_per_page'];
                }
                if (!empty($_POST['lots_fromcats_per_page'])) {
                    $config['modules']['lots']['lots_fromcats_per_page'] = $_POST['lots_fromcats_per_page'];
                }
                if (!empty($_POST['lots_comments_limit'])) {
                    $config['modules']['lots']['comments_limit'] = $_POST['lots_comments_limit'];
                }
                if (!empty($_POST['lots_short_tpl'])) {
                    $config['modules']['lots']['short_tpl'] = $_POST['lots_short_tpl'];
                }
                if (!empty($_POST['lots_full_tpl'])) {
                    $config['modules']['lots']['full_tpl'] = $_POST['lots_full_tpl'];
                }
                if (!empty($_POST['default_currency'])) {
                    $config['modules']['lots']['default_currency'] = $_POST['default_currency'];
                }
                $config['modules']['lots']['filter_form'] = $_POST['lots_module_filter'] == 'true';

            }

            // Обновление данных в $config
            require_once(ENGINE_DIR . '/mods/update_config.php');
            header("Location:". $_SERVER['HTTP_REFERER']);
        }
    }

    // Получение списка всех папок с языковыми файлами в папке engine/lang
    $default_langs = array_filter(glob(ENGINE_DIR . '/lang/*'), 'is_dir');
    $default_langs = array_map('basename', $default_langs);

    // Получение списка всех папок в директории templates/
    $skins = array_filter(glob(TEMPLATES_DIR . '/*'), 'is_dir');
    $skins = array_map('basename', $skins);

    foreach ($skins as $key => $skin) {
        if (in_array($skin, $config["excluded_skins"])) {
            unset($skins[$key]);
        }
    }

    if (!empty($config["payment_info"]["included_currencies"])) {
        $config["payment_info"]["included_currencies_str"] = implode(" ", $config["payment_info"]["included_currencies"]);
    }

    $clientVersion = $db_connect->get("client_version", "version", ["client_url[~]" => $_SERVER["HTTP_HOST"]]);
    $updateApi = "https://megadigital.space/engine/api/current_version/check_new_version.php?check";
    $response = file_get_contents($updateApi);
    $data = json_decode($response, true);

    $isLastVersion = true;
    if (!empty($data["version"]) && $data["version"] != $clientVersion) {
        $isLastVersion = false;
    }

    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['megamenu']['commonsettings'] . ' - ' . $config['title']);
    $yourData["data"] = $data;
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['commonsettings'] . '</li>
    ');
    $smarty->assign("isLastVersion", $isLastVersion);
    $smarty->assign("clientVersion", $clientVersion);
    $smarty->assign("server_addr", $_SERVER["SERVER_ADDR"]);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('timezones', $timezones);
    $smarty->assign('skins', $skins);
    $smarty->assign('default_langs', $default_langs);