<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

// Путь к config.php относительно текущего файла
require_once(ENGINE_DIR . '/data/config.php');
require_once(ENGINE_DIR . '/mods/database_helper.php');

if (isset($_POST["create_subscription"]) && $_POST["form_key"] == $_SESSION["subscription_form_key"]) {
    $db_connect->insert("subscriptions", [
        "name" => $_POST["name"],
        "duration_days" => "",
        "discount_percent" => $_POST["discount_percent"],
        "discount_sum" => $_POST["discount_sum"],
        "widget_id" => $_POST["widget_id"],
    ]);
    header("Location: ".$_SERVER["HTTP_REFERER"]);
}

if (isset($_POST["edit_subscription"]) && $_POST["form_key"] == $_SESSION["subscription_form_key"] && !empty($_POST["subs_id"])) {
    $db_connect->update("subscriptions", [
        "name" => $_POST["name"],
        "duration_days" => "",
        "discount_percent" => $_POST["discount_percent"],
        "discount_sum" => $_POST["discount_sum"],
        "widget_id" => $_POST["widget_id"],
    ], ["id" => $_POST["subs_id"]]);
    header("Location: ".$_SERVER["HTTP_REFERER"]);
}


// Получаем список промокодов
$subscriptions = $db_connect->select("subscriptions", "*");
if (!isset($_SESSION['subscription_form_key'])) {
    $_SESSION['subscription_form_key'] = uniqid();
}

foreach ($subscriptions as &$subscription) {
    $subscription[$lang["datatable"]["name"]] = $subscription["name"];
    $subscription[$lang["datatable"]["duration_days"]] = $subscription["duration_days"];
    $subscription[$lang["datatable"]["discount_percent"]] = $subscription["discount_percent"] == "" ? "0 %" : $subscription["discount_percent"]." %";
    $subscription[$lang["datatable"]["discount_sum"]] = $subscription["discount_sum"] == "" ? 0 : $subscription["discount_sum"];
    $subscription[$lang["datatable"]["created_at"]] = $subscription["created_at"];

    $subscription[$lang["datatable"]["actions"]] = "<button type='button' class='mx-1 bg-transparent border sub_edit' data-id='{$subscription['id']}' onclick='largeModal(`subscriptionEditForm`)'><i class='fa fa-edit'></i></button>
                     ";


}

$subscriptionWidgets = $db_connect->select("payment_widgets", "*", ["w_type" => "subscription"]);

$smarty->registerPlugin('modifier', 'json_encode', function($value) {
    return json_encode($value);
});
// Устанавливаем массив переменных в Smarty
$yourData = array('title' => $lang['megamenu']['subscriptions'] . ' - ' . $config['title']);
$smarty->assign("subscriptions", $subscriptions);
$smarty->assign("subscriptionWidgets", $subscriptionWidgets);

$smarty->assign('data', $yourData);
$smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['subscriptions'] . '</li>
    ');
$smarty->assign('form_key', $_SESSION['subscription_form_key']);
$yourData = array('title' => $lang['nav']['adscategorieslist'] . ' - ' . $config['title']);
$smarty->assign('theme', SYSTEM_DIR);
$smarty->assign('config', $config);
?>
