<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

$topDonaters = $db_connect->select("top_donaters", "*", [
    "ORDER" => ["id" => "DESC"],
]) ?? [];

foreach ($topDonaters as $key => &$topDonater) {
    $user = $db_connect->get("users", "*", ["id" => $topDonater["user_id"]]);

    if (empty($user)) {
        unset($topDonaters[$key]);
        continue;
    }

    $transaction = $db_connect->get("transactions", "*", ["id" => $topDonater["transaction_id"]]);

    $topDonater[$lang["datatable"]["uniq_id"]] = $key + 1;
    if (!empty($user) && !empty($transaction)) {
        $topDonater[$lang["datatable"]["name"]] = $user["name"];
        $topDonater[$lang["datatable"]["email"]] = $user["email"];
        $topDonater[$lang["datatable"]["date"]] = $transaction["date"];
        $topDonater[$lang["datatable"]["sum"]] = $transaction["sum"]." ".$transaction["currency"];
    }
}



$smarty->registerPlugin('modifier', 'json_encode', function($value) {
    return json_encode($value);
});
// Устанавливаем массив переменных в Smarty
$yourData = array('title' => $lang['megamenu']['topdonaters'] . ' - ' . $config['title']);
$smarty->assign("topDonaters", $topDonaters);
$smarty->assign('data', $yourData);
$smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['topdonaters'] . '</li>
    ');
$yourData = array('title' => $lang['nav']['adscategorieslist'] . ' - ' . $config['title']);
$smarty->assign('theme', SYSTEM_DIR);
$smarty->assign('config', $config);