<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR. '/mods/database_helper.php');

    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    $user = [];
    if ($user_id !== null) {
        $user = $db_connect->get("users", "*",["id" => $user_id]);

        $isOtherProfile = false;
        if ($_SESSION["user_email"] != $user["email"]) {
            $isOtherProfile = true;
        }
        $smarty->assign('isOtherProfile', $isOtherProfile);
        $smarty->assign('user_email', htmlspecialchars($user['email']));
        $smarty->assign('session_user_email', htmlspecialchars($_SESSION["user_email"]));

        foreach ($user as $key => $value) {
            $smarty->assign($key, $value);
        }

        if ($isOtherProfile) {
            $sessionUser = $db_connect->get("users", "*", ["email" => $_SESSION["user_email"]]);

            foreach ($sessionUser as $key => $value) {
                $smarty->assign("session_".$key, $value);
            }
        }
    }
    $smarty->assign('userData', $user);

// Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['sections']['profile']['main']['title'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['sections']['profile']['main']['title'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);