<?php
    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');


    // Обработка формы добавления пользователя
    if (isset($_POST['adduser'])) {
        // Получаем данные из формы
        $email = $_POST['email'];
        $password = $_POST['password'];
        $name = $_POST['name'];
        $group = $_POST['group'];
        $age = $_POST['age'];
        $phone = $_POST['phone'];
        $city = $_POST['city'];
        $gender = $_POST['gender'];

        // Получаем максимальный id пользователя
        $maxIdRow = $db_connect->query("SELECT MAX(id) AS max_id FROM users")->fetch();
        $userId = $maxIdRow['max_id'] + 1;

        // Обработка загруженного изображения avatar
        $avatarPath = handleUploadedFile('avatar', 'uploads/profiles/' . date('Y/n/') . $userId . '/', 'avatar.jpg', $userId);

        if (empty($avatarPath)) {
            $avatarPath = "uploads/profiles/default.svg";
        }

        // Обработка загруженного изображения bg_image
        $bgImagePath = handleUploadedFile('bg_image', 'uploads/profiles/' . date('Y/n/') . $userId . '/', 'bg.jpg', $userId);

        $bio = $_POST['bio'];

        // Хеширование пароля
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Выполняем запрос на добавление пользователя в базу данных с помощью Medoo
        $db_connect->insert('users', [
            'id' => $userId,
            'email' => $email,
            'password' => $hashedPassword,
            'name' => $name,
           // 'group' => (int)$group,
            'age' => (int)$age,
            'phone' => $phone,
            'city' => $city,
            'gender' => $gender,
            'avatar' => $avatarPath,
            'bg_image' => $bgImagePath,
            'bio' => $bio
        ]);

        $db_connect->insert("users_roles", [
            "user_id" => $db_connect->id(),
            "role_id" => $group
        ]);

        // Проверяем результат выполнения запроса
    /*    if ($db_connect->id()) {
            echo "Новый пользователь успешно добавлен!";
        } else {
            echo "Ошибка при добавлении пользователя.";
        }*/

        // Перенаправление на ту же страницу после добавления
        header("Location: {$_SERVER['REQUEST_URI']}");
        exit();
    }

    // Функция для обработки загруженного файла
    function handleUploadedFile($inputName, $uploadDir, $filename, $userId){
        $filePath = ''; // Переменная для хранения пути к сохраненному файлу
        if (isset($_FILES[$inputName]) && $_FILES[$inputName]['error'] == UPLOAD_ERR_OK) {
            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            $filePath = $uploadDir . $filename;
            move_uploaded_file($_FILES[$inputName]['tmp_name'], $filePath);
        }
        return $filePath;
    }

    // Обработка формы удаления пользователя
    if (isset($_POST['deluser'])) {
        $delUsername = $_POST['delusername'];

        $user = $db_connect->get("users", "*", ["name" => $delUsername]);

        if (!empty($user)) {
            $db_connect->delete('users', [
                'id' => $user["id"]
            ]);

            $db_connect->delete("chat_history", ["user_id" => $user["id"]]);
            $db_connect->delete("comment_subscriptions", ["user_id" => $user["id"]]);
            $db_connect->delete("comments", ["user_id" => $user["id"]]);
            $db_connect->delete("deliveries", ["user_id" => $user["id"]]);
            $db_connect->delete("user_applications", ["user_id" => $user["id"]]);
            $db_connect->delete("user_custom_fields", ["user_id" => $user["id"]]);
            $db_connect->delete("top_donaters", ["user_id" => $user["id"]]);

        }

        header("Location: {$_SERVER['REQUEST_URI']}");
        exit();
    }

    // Выполняем запрос для получения полного списка пользователей с использованием Medoo
    $rows = $db_connect->select('users', '*');

    $groups = $db_connect->select('roles', '*');

    // Обработка данных для Smarty
    foreach ($rows as &$row) {

        $userRoleId = $db_connect->get("users_roles", "role_id", ["user_id" => $row["id"]]);

        $roleName = $db_connect->get("roles", "name", ["id" => $userRoleId]);

        $row[$lang["datatable"]["actions"]] = "<div class='btn-group'>
                                    <form method='POST'>
                                        <button type='button' name='deluser' data-user-id='{$row["id"]}' class='mx-1 bg-transparent border editUser'><i class='fa fa-edit'></i></button>
                                    </form>
                                    <form method='POST'>
                                        <input type='hidden' name='delusername' id='delusername' value='{$row["name"]}'>
                                        <button type='submit' onclick='return confirm(`Вы уверены, что хотите удалить этого пользователя?`);' name='deluser' class='mx-1 bg-transparent border text-danger'>X</button>
                                    </form>
                                   
                                </div>";
        $row[$lang["datatable"]["name"]] = "<a href='/admin?action=user-profile&user_id={$row['id']}'>{$row['name']}</a>";
        $row["email"] = $row["email"] == "" || $row["email"] == null ? "Без эл. почты" : $row["email"];
        $row[$lang["datatable"]["group"]] = $roleName;
        $row[$lang["datatable"]["city"]] = $row["city"] == "" || $row["city"] == null ? "Город не указан" : $row["city"];
        $row[$lang["datatable"]["sales"]] = $row["sales"];
        $row[$lang["datatable"]["purchases"]] = $row["purchases"];


    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // Устанавливаем массив переменных в Smarty
    $smarty->assign('rows', $rows);
    $yourData = array('title' => $lang['nav']['usermanagement'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('groups', $groups);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['usermanagement'] . '</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);