<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Массив папок для исключения
    $excludedFolders = ['.', '..', 'svg'];

    // Укажите новый путь к tpl файлам
    $tplDirectory = 'templates/' . $config['skin'] . '/';
    $subAction = isset($_GET['sub_action']) ? $_GET['sub_action'] : '';
    if ($subAction === 'edit') {
        $tplFile = isset($_GET['tpl_file']) ? $_GET['tpl_file'] : '';

        if (!empty($tplFile)) {
            $tplFilePath = $tplDirectory . $tplFile;
            $tplContent = file_get_contents($tplFilePath);
            $tplContentEscaped = htmlspecialchars($tplContent, ENT_QUOTES, 'UTF-8');
            $smarty->assign('tpl_file', $tplFile);
            $smarty->assign('tpl_content', $tplContentEscaped);
        }
    } elseif ($subAction === 'save') {
        $tplFile = isset($_POST['tpl_file']) ? $_POST['tpl_file'] : '';
        $tplContent = isset($_POST['tpl_content']) ? $_POST['tpl_content'] : '';
        if (!empty($tplFile)) {
            $tplFilePath = $_SERVER["DOCUMENT_ROOT"] . "/" . $tplDirectory . $tplFile;
            if (!is_writable($tplFilePath)) {
                if (!chmod($tplFilePath, 0666)) {
                    echo "Не удалось изменить права на файл.";
                    exit;
                }
            }

            if (!is_writable($tplFilePath)) {
                echo "Нет прав на запись в директорию: $tplFilePath";
                exit;
            }

            if (file_put_contents($tplFilePath, htmlspecialchars_decode($tplContent, ENT_QUOTES)) === false) {
                echo "Не удалось записать в файл: $tplFilePath\n";

                // Дополнительная информация о причине ошибки
                $error = error_get_last();
                echo "Ошибка: " . $error['message'] . "\n";
                exit;
            }
            // Отправляем сообщение об успешном сохранении
            echo 'Файл успешно сохранен.';
            exit;
        }
    } elseif ($subAction === 'view') {
        $folder = isset($_GET['folder']) ? $_GET['folder'] : '';
        if (!empty($folder)) {
            $folderPath = $tplDirectory . $folder;
            $folderFiles = scandir($folderPath);
            $folderFiles = array_diff($folderFiles, $excludedFolders);
            // Фильтруем только tpl файлы
            $tplFiles = array_filter($folderFiles, function ($file) {
                return pathinfo($file, PATHINFO_EXTENSION) === 'tpl';
            });
            $smarty->assign('tpl_files', $tplFiles);
            $smarty->assign('folder_name', $folder);
        }
    } else {
        // Получить все файлы и папки в основной директории шаблонов
        $allFiles = scandir($tplDirectory);
        $allFiles = array_diff($allFiles, $excludedFolders);
        // Отфильтровать только tpl файлы
        $tplFiles = array_filter($allFiles, function ($file) {
            return pathinfo($file, PATHINFO_EXTENSION) === 'tpl';
        });
        $smarty->assign('tpl_files', $tplFiles);
    }

    function getTplFilesRecursive($directory, $baseDir = '', $excludedFolders = []) {
        $items = [
            'folders' => [],
            'files' => []
        ];
        $files = scandir($directory);
        foreach ($files as $file) {
            if (in_array($file, $excludedFolders, true)) {
                continue;
            }
            $filePath = $directory . '/' . $file;
            $relativePath = ltrim($baseDir . '/' . $file, '/');
            if (is_dir($filePath)) {
                // Добавляем папки
                $items['folders'][$file] = getTplFilesRecursive($filePath, $relativePath, $excludedFolders);
            } elseif (pathinfo($file, PATHINFO_EXTENSION) === 'tpl' || pathinfo($file, PATHINFO_EXTENSION) === 'css' || pathinfo($file, PATHINFO_EXTENSION) === 'js') {
                // Добавляем файлы
                $items['files'][] = $relativePath;
            }
        }

        // Сортируем папки и файлы
        ksort($items['folders']);
        sort($items['files']);

        return $items;
    }

    // Получение структуры шаблонов
    $tplFiles = getTplFilesRecursive($tplDirectory, '', $excludedFolders);
    $smarty->assign('tpl_files', $tplFiles);
    $smarty->assign('tplDirectory', $tplDirectory);

    function smarty_modifier_basename($filePath) {
        return basename($filePath);
    }

    // Регистрируем модификатор
    $smarty->registerPlugin('modifier', 'basename', 'smarty_modifier_basename');

    $yourData = array('title' => $lang['nav']['websitetemplates'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['websitetemplates'] . '</li>
    ');