<?php
    /*
             *****************************************************************************
             * MEGA Digital Space - by MEGA Digital Studio                               *
             * ------------------------------------------------------------------------- *
             * CMS Website:  https://megadigital.space                                   *
             * License:  https://megadigital.space/license                               *
             * Owner:  Giorgi Basharuli                                                  *
             * Contact:  online@megadigital.studio                                       *
             * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
             * Website:  https://megadigital.studio                                      *
             * ------------------------------------------------------------------------- *
             * Description: This file is a part of the MEGA Digital Space CMS system.    *
             * Unauthorized distribution, modification, or commercial use is strictly -  *
             * prohibited without prior written permission.                              *
             * ------------------------------------------------------------------------- *
             * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
             * All rights reserved.                                                      *
             *****************************************************************************
         */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/database_helper.php');


    $settings = [];

    if (isset($_POST["edit_participation"]) && !empty($_POST["participation_id"])) {

        if (!empty($_POST["rgb_first"])) {
            $settings["rgb_first"] = $_POST["rgb_first"];
        }
        if (!empty($_POST["rgb_second"])) {
            $settings["rgb_second"] = $_POST["rgb_second"];
        }
        if (!empty($_POST["parent_widget_id"])) {
            $settings["parent_widget_id"] = $_POST["parent_widget_id"];
        }

        $db_connect->update("participations", [
            "group_id" => (int)$_POST["group_id"],
            "name" => $_POST["name"],
            "max_user_count" => (int)$_POST["max_user_count"],
            "settings" => json_encode($settings),
            "template_name" => $_POST["template_name"],

        ], [
            "id" => $_POST["participation_id"]
        ]);

        $db_connect->delete("widgets_translations", ["widget_id" => $_POST["participation_id"], "widget_type" => "participation_widget"]);

        foreach ($_POST["translations"] as $lng => $translationAssoc) {
            foreach ($translationAssoc as $k => $v) {
                $db_connect->insert("widgets_translations", [
                    "widget_id" => $_POST["participation_id"],
                    "widget_type" => "participation_widget",
                    "lang_code" => $lng,
                    "name" => $k,
                    "value" => $v,
                ]);
            }
        }

        header("Location: /admin?action=widgets/participations/list");

    }
    $groups = $db_connect->select("roles", "*");

    if (!isset($_SESSION['category_form_key'])) {
        $_SESSION['category_form_key'] = uniqid();
    }
    require_once (ENGINE_DIR . '/mods/directory_files_folders.php');
    $fileManager = new FileManager($db_connect);
    $participationCustomTemplates = $fileManager->getFilesAndFolders($_SERVER["DOCUMENT_ROOT"]."/templates/main/widgets/custom/participation");

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign('langs', $availableLanguagesList);

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('pageId', $_GET["id"]);
    $yourData = array('title' => $lang['nav']['participations'] . ' - ' . $config['title']);
    $smarty->assign("participations", $participations);
    $smarty->assign("groups", $groups);
    $smarty->assign('data', $yourData);
    $smarty->assign('participationCustomTemplates', $participationCustomTemplates);
    $smarty->assign('page_name', '
                    <li class="breadcrumb-item active">' . $lang['nav']['participations'] . '</li>
                ');
    $smarty->assign('form_key', $_SESSION['category_form_key']);
    $yourData = array('title' => $lang['nav']['adscategorieslist'] . ' - ' . $config['title']);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);