<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    $settings = [];


    if (isset($_POST["delete_participation_w"]) && !empty($_POST["participation_id"])) {
        $db_connect->delete("participations", ["id" => $_POST["participation_id"]]);

        $db_connect->delete("widgets_translations", ["widget_id" => $_POST["participation_id"], "widget_type" => "participation_widget"]);

        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }


    if (!isset($_SESSION['category_form_key'])) {
        $_SESSION['category_form_key'] = uniqid();
    }
    $participations = $db_connect->select("participations", "*");
    $groups = $db_connect->select("roles", "*");

    foreach ($participations as $key => &$participation) {
        $participation[$lang["datatable"]["name"]] = $db_connect->get("widgets_translations", "value", ["widget_id" => $participation["id"], "widget_type" => "participation_widget", "name" => "name", "lang_code" => $_SESSION["lang"] ?? $config['default_lang']]);
        $participation[$lang["datatable"]["max_users_count"]] = $participation["max_user_count"];
        $participation[$lang["datatable"]["uniq_name"]] = $participation["uniq_name"];

        $participation[$lang["datatable"]["uniq_id"]] = $key + 1;
        $participation[$lang["datatable"]["group"]] = $db_connect->get("roles", "name", ["id" => $participation["group_id"]]);

        if (isset($participation["template_name"]) && $participation["template_name"] == "auto") {
            $includeText = "{include file=\"templates/{$config["skin"]}/widgets/participation_widget.tpl\" uniqName=\"{$participation["uniq_name"]}\"  gradient1=\"#616161\" rgba=\"rgba(39,51,114,0.56)\" }";
        } else {
            $includeText = '{include file="templates/'.$config["skin"].'/widgets/custom/participation/' . ($participation["template_name"] ?? "") . '" customUniqName="' . $participation["uniq_name"] . '" }';
        }

        $participation[$lang["datatable"]["actions"]] = "<a href='#' id='copy-ico' data-copy='{$includeText}' class='mx-3 fa fa-copy'></a><a href='/admin?action=widgets/participations/edit&id={$participation['id']}' data-id='{$participation['id']}' class='mx-1 bg-transparent border'><i class='fa fa-edit'></i></a>
                            <form method='POST' action='/admin?action=/widgets/participations' style='display:inline;'>
                                <input type='hidden' name='form_key' value='{$_SESSION['category_form_key']}'>
                                <input type='hidden' name='participation_id' value='{$participation['id']}'>
                                <input type='hidden' name='delete_participation_w' value='1'>
                                <button type='submit' class='no-b mx-1' name='delete_participation_w' onclick='return confirm(\"Вы уверены, что хотите удалить счетчик?\");'>
                                    <i class='fa fa-trash'></i>
                                </button>
                            </form>";
    }

    if (!isset($_SESSION['category_form_key'])) {
        $_SESSION['category_form_key'] = uniqid();
    }
    require_once (ENGINE_DIR . '/mods/directory_files_folders.php');
    $fileManager = new FileManager($db_connect);
    $participationCustomTemplates = $fileManager->getFilesAndFolders($_SERVER["DOCUMENT_ROOT"]."/templates/main/widgets/custom/participation");

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign('langs', $availableLanguagesList);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['participations'] . ' - ' . $config['title']);
    $smarty->assign("participations", $participations);
    $smarty->assign("groups", $groups);
    $smarty->assign('data', $yourData);
    $smarty->assign('participationCustomTemplates', $participationCustomTemplates);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['participations'] . '</li>
        ');
    $smarty->assign('form_key', $_SESSION['category_form_key']);
    $yourData = array('title' => $lang['nav']['adscategorieslist'] . ' - ' . $config['title']);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);