<?php
    /*
             *****************************************************************************
             * MEGA Digital Space - by MEGA Digital Studio                               *
             * ------------------------------------------------------------------------- *
             * CMS Website:  https://megadigital.space                                   *
             * License:  https://megadigital.space/license                               *
             * Owner:  Giorgi Basharuli                                                  *
             * Contact:  online@megadigital.studio                                       *
             * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
             * Website:  https://megadigital.studio                                      *
             * ------------------------------------------------------------------------- *
             * Description: This file is a part of the MEGA Digital Space CMS system.    *
             * Unauthorized distribution, modification, or commercial use is strictly -  *
             * prohibited without prior written permission.                              *
             * ------------------------------------------------------------------------- *
             * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
             * All rights reserved.                                                      *
             *****************************************************************************
         */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/database_helper.php');


    $groups = [];
    foreach ($config["default_roles"] as $key => $value) {
        if ($key != "roles_from_confirm") {
            $groups[] = $key;
        }
    }

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign("pageId", $_GET["id"]);
    $smarty->assign('langs', $availableLanguagesList);
    $smarty->assign("emailTemplates", $templates);
    $smarty->assign("widgets", $widgets);
    $smarty->assign("groups", $groups);
    $yourData = array('title' => $lang['nav']['quizes'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
                <li class="breadcrumb-item active">' . $lang['nav']['quizes'] . '</li>
            ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);