<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/database_helper.php');

    global $db_connect;

    $quizList = $db_connect->select("quiz", "*");
    $quizAnswers = $db_connect->get("quiz_answers", "*");
    $quizQuestions = $db_connect->get("quiz_questions", "*");
    $quizParticipations = $db_connect->get("quiz_participations", "*");


    foreach ($quizList as $key => &$quizAssoc) {

        $quizAssoc[$lang["datatable"]["uniq_id"]] = $key + 1;

        if ($quizAssoc["template_name"] == "auto") {
            $includeText = '{include file="templates/'.$config["skin"].'/widgets/quiz_widget.tpl" uniqName="'.$quizAssoc["uniq_name"].'"}';
        } else {
            $includeText = '{include file="templates/'.$config["skin"].'/widgets/custom/quiz/'.$quizAssoc["template_name"].'"'.' customUniqName="'.$quizAssoc["uniq_name"].'"}';
        }

        $quizAssoc[$lang["datatable"]["actions"]] = "<a href='#' id='copy-ico' data-copy='{$includeText}' class='mx-3 fa fa-copy'></a>";

        $quizAssoc[$lang["datatable"]["name"]] = $db_connect->get("widgets_translations", "value", ["widget_id" => $quizAssoc["id"], "widget_type" => "quiz_widget", "name" => "main_title", "lang_code" => $_SESSION["lang"] ?? $config['default_lang']]);;
        $quizAssoc[$lang["datatable"]["type"]] = $quizAssoc["type"];
        $quizAssoc[$lang["datatable"]["by_country"]] = $quizAssoc["by_country"];
        $quizAssoc[$lang["datatable"]["uniq_name"]] = $quizAssoc["uniq_name"];

    }


    if (!isset($_SESSION['quiz_form_key'])) {
        $_SESSION['quiz_form_key'] = uniqid();
    }
    require_once (ENGINE_DIR . '/mods/directory_files_folders.php');
    $fileManager = new FileManager($db_connect);
    $quizCustomTemplates = $fileManager->getFilesAndFolders($_SERVER["DOCUMENT_ROOT"]."/templates/main/widgets/custom/quiz");

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign('langs', $availableLanguagesList);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['quizes'] . ' - ' . $config['title']);
    $smarty->assign("quizList", $quizList);
    $smarty->assign('data', $yourData);
    $smarty->assign('quizCustomTemplates', $quizCustomTemplates);

    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['quizes'] . '</li>
        ');
    $smarty->assign('form_key', $_SESSION['quiz_form_key']);
    $yourData = array('title' => $lang['nav']['quizwidgets'] . ' - ' . $config['title']);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);