<?php
    /*
          *****************************************************************************
          * MEGA Digital Space - by MEGA Digital Studio                               *
          * ------------------------------------------------------------------------- *
          * CMS Website:  https://megadigital.space                                   *
          * License:  https://megadigital.space/license                               *
          * Owner:  Giorgi Basharuli                                                  *
          * Contact:  online@megadigital.studio                                       *
          * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
          * Website:  https://megadigital.studio                                      *
          * ------------------------------------------------------------------------- *
          * Description: This file is a part of the MEGA Digital Space CMS system.    *
          * Unauthorized distribution, modification, or commercial use is strictly -  *
          * prohibited without prior written permission.                              *
          * ------------------------------------------------------------------------- *
          * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
          * All rights reserved.                                                      *
          *****************************************************************************
      */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/database_helper.php');

    $settings = [];
    if (isset($_POST["create_wall"])) {

        $db_connect->insert("walls", [
            "uniq_name" => generateUniqueCode(),
            "settings" => json_encode($settings),
            "title" => $_POST["title"],
            "description" => $_POST["description"],
            "visibility_type" => $_POST["visibility_type"],
            "posting_access_type" => $_POST["posting_access_type"],
            "created_at" => date("Y-m-d H:i:s"),
            "owner_id" => (int)$_SESSION["user_id"],
            "template_name" => $_POST["template_name"],

        ]);

        $widgetId = $db_connect->id();

        foreach ($_POST["translations"] as $lng => $translationAssoc) {
            foreach ($translationAssoc as $k => $v) {
                $db_connect->insert("widgets_translations", [
                    "widget_id" => $widgetId,
                    "widget_type" => "wall_widget",
                    "lang_code" => $lng,
                    "name" => $k,
                    "value" => $v,
                ]);
            }
        }

        header("Location: /admin?action=widgets/walls/list");
    }

    function generateUniqueCode() {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $code = '';

        for ($i = 0; $i < 5; $i++) {
            $code .= $characters[random_int(0, strlen($characters) - 1)];
        }

        return $code;
    }

    $groups = $db_connect->select("roles", "*");

    if (!isset($_SESSION['walls_form_key'])) {
        $_SESSION['walls_form_key'] = uniqid();
    }

    require_once (ENGINE_DIR . '/mods/directory_files_folders.php');
    $fileManager = new FileManager($db_connect);
    $wallsCustomTemplates = $fileManager->getFilesAndFolders($_SERVER["DOCUMENT_ROOT"]."/templates/main/widgets/custom/wall");

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign('langs', $availableLanguagesList);
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['walls'] . ' - ' . $config['title']);
    $smarty->assign("wallsCustomTemplates", $wallsCustomTemplates);
    $smarty->assign("groups", $groups);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
                <li class="breadcrumb-item active">' . $lang['nav']['walls'] . '</li>
            ');
    $smarty->assign('form_key', $_SESSION['walls_form_key']);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);