<?php
    /*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/


    $settings = [];

    if (isset($_POST["delete_wall_w"]) && !empty($_POST["wall_id"])) {
        $db_connect->delete("walls", ["id" => $_POST["wall_id"]]);

        $db_connect->delete("widgets_translations", ["widget_id" => $_POST["wall_id"], "widget_type" => "wall_widget"]);

        header("Location: ".$_SERVER["HTTP_REFERER"]);
    }



    if (!isset($_SESSION['walls_form_key'])) {
        $_SESSION['walls_form_key'] = uniqid();
    }

    $wallWidgets = $db_connect->select("walls", "*");
    $groups = $db_connect->select("roles", "*");


    foreach ($wallWidgets as $key => &$wallWidget) {

        if ($wallWidget["visibility_type"] === 1) {
            $wallWidget["visibility_type"] = "Public";
        } else if ($wallWidget["visibility_type"] === 2) {
            $wallWidget["visibility_type"] = "Private";
        } else if ($wallWidget["visibility_type"] === 3) {
            $wallWidget["visibility_type"] = "Restricted";
        }

        if ($wallWidget["posting_access_type"] === 1) {
            $wallWidget["posting_access_type"] = "All";
        } else if ($wallWidget["posting_access_type"] === 2) {
            $wallWidget["posting_access_type"] = "Followers";
        } else if ($wallWidget["posting_access_type"] === 3) {
            $wallWidget["posting_access_type"] = "Owner Only";
        }

        $wallWidget[$lang["datatable"]["visibility_type"]] = $wallWidget["visibility_type"];
        $wallWidget[$lang["datatable"]["posting_access_type"]] = $wallWidget["posting_access_type"];

        $wallWidget[$lang["datatable"]["description"]] = $db_connect->get("widgets_translations", "value", ["widget_id" => $wallWidget["id"], "widget_type" => "wall_widget", "name" => "description", "lang_code" => $_SESSION["lang"] ?? $config['default_lang']]);
        $wallWidget[$lang["datatable"]["title"]] = $db_connect->get("widgets_translations", "value", ["widget_id" => $wallWidget["id"], "widget_type" => "wall_widget", "name" => "title", "lang_code" => $_SESSION["lang"] ?? $config['default_lang']]);
        $wallWidget[$lang["datatable"]["created_at"]] = $wallWidget["created_at"];
        $wallWidget[$lang["datatable"]["uniq_name"]] = $wallWidget["uniq_name"];

        $includeText = '{include file="templates/'.$config["skin"].'/widgets/custom/wall/' . ($wallWidget["template_name"] ?? "") . '" customUniqName="' . $wallWidget["uniq_name"] . '" }';


        $wallWidget[$lang["datatable"]["actions"]] = "<a href='#' id='copy-ico' data-copy='{$includeText}' class='mx-3 fa fa-copy'></a><a href='/admin?action=widgets/walls/edit&id={$wallWidget['id']}' data-id='{$wallWidget['id']}' class='mx-1 bg-transparent border'><i class='fa fa-edit'></i></a>
                        <form method='POST' action='/admin?action=/widgets/walls' style='display:inline;'>
                            <input type='hidden' name='form_key' value='{$_SESSION['walls_form_key']}'>
                            <input type='hidden' name='wall_id' value='{$wallWidget['id']}'>
                            <input type='hidden' name='delete_wall_w' value='1'>
                            <button type='submit' class='no-b mx-1' name='delete_wall_w' onclick='return confirm(\"Вы уверены, что хотите удалить стену?\");'>
                                <i class='fa fa-trash'></i>
                            </button>
                        </form>";
    }

    require_once (ENGINE_DIR . '/mods/directory_files_folders.php');
    $fileManager = new FileManager($db_connect);
    $wallsCustomTemplates = $fileManager->getFilesAndFolders($_SERVER["DOCUMENT_ROOT"]."/templates/main/widgets/custom/wall");

    $availableLanguagesList = [];
    foreach ($available_languages as $available_language) {
        $availableLanguagesList[] = [
            "code" => $available_language,
            "name" => $available_language
        ];
    }

    $smarty->assign('langs', $availableLanguagesList);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['walls'] . ' - ' . $config['title']);
    $smarty->assign("wallWidgets", $wallWidgets);
    $smarty->assign("wallsCustomTemplates", $wallsCustomTemplates);
    $smarty->assign("groups", $groups);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['walls'] . '</li>
        ');
    $smarty->assign('form_key', $_SESSION['walls_form_key']);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);