<script src="{$stheme}/js/slugify.js"></script>
<script>
    // Ждем полной загрузки DOM перед выполнением скрипта
    document.addEventListener('DOMContentLoaded', function () {
        // Функция генерации ЧПУ URL с использованием slugify
        function generateSlug(title) {
            let slug = slugify(title, {
                lower: true,       // Приводим к нижнему регистру
                replacement: '-',  // Используем дефис как разделитель
                remove: /[*+~.()'"!:@]/g // Убираем ненужные символы
            });
            return slug;
        }
        // Обрабатываем событие ввода в поле "Название страницы"
        const titleInput = document.getElementById('title');
        const slugInput = document.getElementById('alt_name');
        const submitButton = document.getElementById('submitButton');
        if (titleInput && slugInput) {  // Проверяем, что элементы существуют
            titleInput.addEventListener('input', function () {
                const title = this.value;                  // Получаем значение из поля ввода
                const slug = generateSlug(title);          // Генерируем slug
                slugInput.value = slug;                    // Выводим slug в поле для URL
            });
            // Обрабатываем нажатие на кнопку "Submit"
            submitButton.addEventListener('click', function (event) {
                const title = titleInput.value;    // Получаем значение названия страницы
                if (!slugInput.value) {            // Если поле ЧПУ URL пустое, генерируем URL заново
                    const slug = generateSlug(title);
                    slugInput.value = slug;
                }
            });
        } else {
            console.error('Не удалось найти элементы с ID "title" или "alt_name".');
        }
    });
</script>