<div id="license" class="hidden">
    <div class="col-12">
        {if $config.license == ''}
            <div class="card">
                <div class="card-body rounded-1" style="border: 1px solid var(--theme-color1)">
                    <div>
                        <a href="https://megadigital.space/license_buy" class="btn btn-sm btn-warning py-0 mb-3 float-end" target="_blank">Получить лицензию</a>
                        <h4>{$lang.nav.unlicensed} Mega Digital Space</h4>
                    </div>
                    <p>Вы используете неактивированную версию <b>Mega Digital Space</b>. Для снятия ограничений введите ключ активации. Активация применяется только к указанному домену, где будет постоянно использоваться лицензия. Не активируйте CMS на тестовых сайтах. Процесс активации осуществляется в личном кабинете на нашем сайте, по адресу <a href="https://megadigital.space/profile">https://megadigital.space/profile</a>.</p>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <form method="POST" action="engine/license/check_license.php">
                            <div class="col-12 btn-group">
                                <input type="text" class="form-control rounded-0" name="license_key" placeholder="Введите ключ для активации лицензии" style="border-color: var(--theme-color1)">
                                <div class="form-icon position-absolute">
                                    <img src="{$stheme}/images/svg/lock-key.svg" alt="">
                                </div>
                                <button type="submit" class="btn btn-success">Активировать</button>
                            </div>
                        </form>
                    </fieldset>
                    <p class="fs-6 mb-0">Лицензионный ключ должен иметь формат: <span class="text-danger">XXXXX-XXXXX-XXXXX-XXXXX-XXXXX</span></p>
                </div>
            </div>
        {else}
            <div class="card">
                <div class="card-body rounded-1" style="border: 1px solid var(--theme-color1)">
                    <div>
                        <h4>{$lang.nav.licensed}</h4>
                    </div>
                    <p class="mb-0">{$lang.nav.licensekey}:</p>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <div class="col-12 btn-group">
                            <input type="text" class="form-control rounded-0" value="{$config.license}" style="border-color: var(--theme-color1)">
                            <div class="form-icon position-absolute">
                                <img src="{$stheme}/images/svg/lock-key.svg" alt="">
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
        {/if}
    </div>
</div>