{foreach from=$tasks item=task}
    <li class="col-12">
        <div class="card border-0 mb-3">
            <div class="card-body">
                <table class="table mb-0">
                    <tbody>
                        <tr>
                            <td width="70%" class="border-bottom-0 p-0">
                                <a class="btn btn-outline-secondary btn-sm" onclick="smallModal('{$task.id}')">
                                    {$task.title|truncate:30:" ..."}
                                </a>
                            </td>
                            <td class="border-start border-bottom-0 text-center p-0" width="10%">
                                {if $task.status == 'pending'}
                                    <span class="text-warning"><i class="fa fa-clock-o fa-spin"></i></span>
                                {elseif $task.status == 'inprogress'}
                                    <span class="text-primary"><i class="fa fa-spinner fa-spin"></i></span>
                                {/if}
                            </td>
                            <td class="border-start border-bottom-0 text-center p-0" width="10%">
                                <form method="post" id="delete-task" class="d-inline-block">
                                    <input type="hidden" name="action" value="delete_task">
                                    <input type="hidden" name="task_id" value="{$task.id}">
                                    <input type="hidden" name="delete_current_url" value="{$current_url}">
                                    <button type="submit" class="btn btn-danger btn-sm"  onclick="return confirm('Вы уверены, что хотите удалить это задание?');">
                                        <i class="fa fa-times"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div id="{$task.id}" class="hidden">
                    <div class="col-12">
                        <h5 class="pb-2 border-bottom">{$task.title}</h5>
                        <p class="pb-2 border-bottom">{$task.description|unescape}</p>
                        <!-- Форма для смены статуса задания -->
                        <form method="post" id="update-status" class="status mt-2">
                            <input type="hidden" name="action" value="update_status">
                            <input type="hidden" name="task_id" value="{$task.id}">
                            <input type="hidden" name="update_current_url" value="{$current_url}">
                            <div class="btn-group w-100">
                                <select name="status" class="form-select">
                                    <option value="pending" {if $task.status == 'pending'}selected{/if}>В ожидании</option>
                                    <option value="inprogress" {if $task.status == 'inprogress'}selected{/if}>Выполняется</option>
                                </select>
                                <button type="submit" class="btn btn-outline-secondary btn-sm">Обновить статус</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </li>
{/foreach}