
<li class="nav-item user">
    <a class="dropdown-toggle {if !isset($user_authenticated) || !$user_authenticated}dropdown-avatar{/if} gray-6 d-flex text-decoration-none align-items-center lh-sm p-0" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" title="User" data-bs-auto-close="outside">
        <img class="avatar rounded-1 border border-3" src="{$avatar}" alt="avatar">
        <span class="ms-2 fs-6 d-none d-sm-inline-flex">{$user_name}</span>
    </a>
    <div class="dropdown-menu dropdown-menu-end shadow p-2 p-xl-3 rounded-2 {if isset($user_authenticated) && $user_authenticated}authenticated{/if}">
        {if isset($user_authenticated) && $user_authenticated}
            <div class="bg-body p-3 rounded-3">
                <h4 class="mb-1 title-font">{$user_name}</h4>
                <p class="small text-muted mb-2"><b>{$lang.header.email}:</b> {$user_email}</p>
                <p class="small text-muted mb-0"><b>{$lang.header.group}:</b> {$group_name}</p><hr>
                <p class="small text-muted mb-0"><b>Subscription:</b>{if isset($userSubscription)} {$userSubscription} {else}  {/if}</p>
            </div>

            <ul class="list-unstyled mt-2">
                <li>
                    <a class="dropdown-item rounded-1" aria-label="my wallet" href="/?myWallet">
                        <span class="align-middle">
                            {$lang.header.balance}:
                            <span class="fw-bold text-success">
                                <span
                                        data-purecounter-start="0"
                                        data-purecounter-separator=","
                                        data-purecounter-currency="$"
                                        data-purecounter-end="{$user_balance}"
                                        class="purecounter">
                                    {$user_balance} {$currency}
                                </span>
                            </span>
                        </span>
                    </a>
                </li>

                <a class="dropdown-item rounded-1" href="/profile">{$lang.header.profile_settings}</a>

                {if $access['mna.create']}
                    <a class="dropdown-item rounded-1" href="/admin">{$lang.header.control_panel}</a>
                {/if}

                {if !empty($rulesForAdd)}
                    <form method="post" action="/?addObject">
                        <div class="bg-body p-3 rounded-3">
                            <li>
                                <div class="d-flex align-items-center gap-2">
                                    <select class="form-select form-select-sm w-75" name="object" aria-label="Select type">
                                        {foreach $rulesForAdd as $ruleForAdd}
                                            <option value="{$ruleForAdd}" selected>{$ruleForAdd}</option>
                                        {/foreach}
                                    </select>
                                    <button type="submit" class="btn btn-primary btn-sm">Добавить</button>
                                </div>
                            </li>
                        </div>
                    </form>
                {/if}

                <li class="dropdown-divider"></li>
            </ul>

            <a class="btn py-2 btn-primary w-100 mt-2 rounded-1" href="#" onclick="logout(event)">
            <img src="{$stheme}/svg/logout.svg" alt="">
            <span style="top: 1.5px; left:3px; position: relative;">{$lang.header.logout}</span>
        </a>
        <script>
            function logout(event) {
                var xhr = new XMLHttpRequest();
                xhr.open('GET', '/engine/logout.php', true);
                xhr.onload = function () {
                    location.reload();
                };
                xhr.send();
                event.preventDefault();
            }
        </script>
        {else}
            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pills-sign-in" data-bs-toggle="pill" data-bs-target="#pills-signin" type="button" role="tab" aria-controls="pills-signin" aria-selected="true">{$lang.header.login}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-sign-up" data-bs-toggle="pill" data-bs-target="#pills-signup" type="button" role="tab" aria-controls="pills-signup" {if $hideRegistrationForm } onclick="window.location.href= '/registration'" {/if} aria-selected="false">{$lang.header.create_account}</button>
                </li>
            </ul>
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-signin" role="tabpanel" aria-labelledby="pills-sign-in">
                    {$login}
                </div>
                <div class="tab-pane fade" id="pills-signup" role="tabpanel" aria-labelledby="pills-sign-up" {if $hideRegistrationForm } href="/registration" {/if}>
                    {$registration}
                </div>
            </div>
        {/if}
        <div class="mt-2 btn-group w-100">
            <a class="btn btn-outline-secondary btn-sm" id="openPolicy">{$lang.header.policy}</a>
            <a class="btn btn-outline-secondary btn-sm" id="openTerms">{$lang.header.terms}</a>
            <a class="btn btn-outline-secondary btn-sm" id="openCookies">{$lang.header.cookies}</a>
        </div>
    </div>
</li>