<aside class="ps-3 pe-2 py-4 sidebar" data-bs-theme="none">
    <nav class="navbar navbar-expand-xl py-0">
        <div class="offcanvas offcanvas-start" data-bs-scroll="true" tabindex="-1" id="offcanvas_Navbar">
            <div class="offcanvas-header">
                <div class="d-flex">
                    <a href="/se-cms/" class="brand-icon mx-3" title="">
                        <img src="{$stheme}/images/logo-icon.svg" class="pe-1" alt="">
                        <svg xmlns="http://www.w3.org/2000/svg" class="d-none d-xl-inline-flex" width="230" height="32" style="padding-top: 5px;">
                            <text x="10" y="20" class="manropebold">MEGADIGITAL.SPACE</text>
                        </svg>
                    </a>
                </div>
                <button type="button" class="btn-close btn-close-white me-2" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body flex-column custom_scroll ps-4 ps-xl-0">
                <!-- start: Workspace -->
                <h6 class="fl-title title-font ps-2 small text-uppercase text-muted" style="--text-color: var(--accent-color)">Все разделы</h6>
                <ul class="list-unstyled menu-list">
                    <li>
                        <a href="/" class="border-success" id="homeLink">
                            <img src="{$theme}/svg/home.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.home}</span>
                        </a>
                    </li>
                    <li>
                        <a href="/news" class="border-success" id="newsLink">
                            <img src="{$theme}/svg/news.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.news}</span>
                        </a>
                    </li>
                    <li>
                        <a href="/modules" id="modulesList">
                            <img src="{$theme}/svg/modules.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.modules}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="/chat" class="nav-link" data-bs-popup="popover" data-bs-trigger="hover" data-bs-content="Чат">
                            <img src="{$theme}/svg/forum.svg" alt="">
                            <span class="mx-2">{$lang.chat.online_chat}</span>
                        </a>
                    </li>
                    <li>
                        <a href="#tools" id="toolsSection" data-bs-toggle="collapse" aria-expanded="false" class="dropdown-toggle" aria-label="tools">
                            <img src="{$theme}/svg/info.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.info}</span>
                        </a>
                        <ul class="collapse list-unstyled" id="tools">
                            <li><a href="/license">{$lang.leftmenu.license}</a></li>
                            <li><a href="#">{$lang.leftmenu.se_requirements}</a></li>
                            <li><a href="#">{$lang.leftmenu.se_capabilities}</a></li>
                            <li><a href="#">{$lang.leftmenu.instructions}</a></li>
                            <li><a href="#">{$lang.leftmenu.support}</a></li>
                            <li><a href="https://docs.megadigital.space/">{$lang.leftmenu.docs}</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="/demonstration" class="border-success" id="demonstration">
                            <img src="{$theme}/svg/download.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.demo}</span>
                        </a>
                    </li>
                    <li>
                        <a href="/license_buy" class="border-success" id="license_buy">
                            <img src="{$theme}/svg/buy.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.license_buy}</span>
                        </a>
                    </li>
                    <li>
                        <a href="https://forum.megadigital.space" class="border-success" id="settingsLink">
                            <img src="{$theme}/svg/forum.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.forum}</span>
                        </a>
                    </li>
                    <li>
                        <a href="/contacts" class="border-success" id="contacts">
                            <img src="{$theme}/svg/mail.svg" alt="">
                            <span class="mx-2">{$lang.leftmenu.contacts}</span>
                        </a>
                    </li>
                </ul>
                <div class="bg-gradient rounded-3 p-4 text-white promo">
                    <a href="#" class="btn btn-sm w-100 btn-dark" id="seVersion">
                        {$lang.leftmenu.mds_version}: <b>v.{$mds_version}</b>
                    </a>
                </div>
            </div>
        </div>
    </nav>
</aside>
<script src="{$theme}/assets/blocks/left_side.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var currentPath = window.location.pathname;
        var activeLink = document.querySelector('a[href="' + currentPath + '"]');
        if (activeLink) {
            activeLink.classList.add('active');
        }
        const validButtons = ['license', 'systemrequired', 'possibilities', 'videoinstructions', 'support', 'documentation'];
        var pathWithoutLeadingSlash = currentPath.replace(/^\/+/, '');
        if (validButtons.includes(pathWithoutLeadingSlash)) {
            var toolsSection = document.getElementById('toolsSection');
            var tools = document.getElementById('tools');
            if (toolsSection) {
                toolsSection.classList.add('active');
            }
            if (tools) {
                tools.classList.add('show');
            }
        }
    });
</script>