<li class="nav-item dropdown d-md-inline-flex">
    <div class="support-widget">
        <div class="support-btn" id="supportButton">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-headset" viewBox="0 0 16 16">
                <path d="M8 1a5 5 0 0 0-5 5v1h1a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V6a6 6 0 1 1 12 0v6a2.5 2.5 0 0 1-2.5 2.5H9.366a1 1 0 0 1-.866.5h-1a1 1 0 1 1 0-2h1a1 1 0 0 1 .866.5H11.5A1.5 1.5 0 0 0 13 12h-1a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h1V6a5 5 0 0 0-5-5"/>
            </svg>
        </div>
{*
        <span class="support-badge">3</span>
*}

        <div class="support-dropdown dropdown-menu" id="supportDropdown">
            <div class="support-header">
                <h5 class="fw-bold mb-1">Поддержка</h5>
                <p class="text-muted small mb-0">Мы онлайн и готовы помочь</p>
            </div>

            <div class="support-option" id="ticketOption">
                <div class="d-flex align-items-center">
                    <div class="bg-light-primary rounded-circle p-2 me-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-ticket" viewBox="0 0 16 16">
                            <path d="M0 4.5A1.5 1.5 0 0 1 1.5 3h13A1.5 1.5 0 0 1 16 4.5V6a.5.5 0 0 1-.5.5 1.5 1.5 0 0 0 0 3 .5.5 0 0 1 .5.5v1.5a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 11.5V10a.5.5 0 0 1 .5-.5 1.5 1.5 0 1 0 0-3A.5.5 0 0 1 0 6zM1.5 4a.5.5 0 0 0-.5.5v1.05a2.5 2.5 0 0 1 0 4.9v1.05a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-1.05a2.5 2.5 0 0 1 0-4.9V4.5a.5.5 0 0 0-.5-.5z"/>
                        </svg>
                    </div>
                    <div>
                        <h6 class="mb-0">Создать тикет</h6>
                        <p class="text-muted small mb-0" style="font-size: 11px">Ответим в течение 24 часов</p>
                    </div>
                </div>
            </div>

           {* <div class="support-option" id="chatOption">
                <div class="d-flex align-items-center">
                    <div class="bg-light-success rounded-circle p-2 me-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="16" fill="currentColor" class="bi bi-chat-right-dots" viewBox="0 0 16 16">
                            <path d="M2 1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h9.586a2 2 0 0 1 1.414.586l2 2V2a1 1 0 0 0-1-1zm12-1a2 2 0 0 1 2 2v12.793a.5.5 0 0 1-.854.353l-2.853-2.853a1 1 0 0 0-.707-.293H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2z"/>
                            <path d="M5 6a1 1 0 1 1-2 0 1 1 0 0 1 2 0m4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0m4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                        </svg>
                    </div>
                    <div>
                        <h6 class="mb-0">Чат с поддержкой</h6>
                        <p class="text-success small mb-0 support-online"></p>
                    </div>
                </div>
            </div>*}
        </div>
    </div>
</li>
<div class="chat-widget-container">
    <div class="chat-toggle" id="chatToggle">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-chat-dots" viewBox="0 0 16 16">
            <path d="M5 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0m4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2"/>
            <path d="m2.165 15.803.02-.004c1.83-.363 2.948-.842 3.468-1.105A9 9 0 0 0 8 15c4.418 0 8-3.134 8-7s-3.582-7-8-7-8 3.134-8 7c0 1.76.743 3.37 1.97 4.6a10.4 10.4 0 0 1-.524 2.318l-.003.011a11 11 0 0 1-.244.637c-.079.186.074.394.273.362a22 22 0 0 0 .693-.125m.8-3.108a1 1 0 0 0-.287-.801C1.618 10.83 1 9.468 1 8c0-3.192 3.004-6 7-6s7 2.808 7 6-3.004 6-7 6a8 8 0 0 1-2.088-.272 1 1 0 0 0-.711.074c-.387.196-1.24.57-2.634.893a11 11 0 0 0 .398-2"/>
        </svg>
{*
        <div class="notification-badge">3</div>
*}
    </div>

    <div id="chatWidget" class="card">
        <div class="chat-header" id="chatHeader">
            <div class="agent-info">
                <div class="agent-avatar">АС</div>
                <div class="agent-details">
                    <div class="agent-name">Онлайн поддержка</div>
                    <div class="agent-status">
                        <span class="status-indicator"></span>
                        <span>Online</span>
                    </div>
                </div>
            </div>
            <div class="header-actions">
              {*  <button class="header-btn" id="minimizeChat">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-dash" viewBox="0 0 16 16">
                        <path d="M4 8a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 4 8"/>
                    </svg>
                </button>*}
                <button class="header-btn" id="closeChat">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-caret-down" viewBox="0 0 16 16">
                        <path d="M3.204 5h9.592L8 10.481zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659"/>
                    </svg>
                </button>
            </div>
        </div>

        <div class="chat-body" id="chatBody">
            <div class="d-flex flex-column align-items-center justify-content-center text-center p-4 h-100 empty-chat">
                <img src="https://cdn-icons-png.flaticon.com/512/542/542638.png" alt="No Messages" class="mb-3" style="width: 80px; opacity: 0.5;">
                <h5 class="text-muted mb-1">Здесь пока пусто</h5>
                <p class="text-secondary mb-0">Начните общение с поддержкой — мы вам обязательно ответим!</p>
            </div>

        </div>

        <div class="chat-footer">
            <div class="input-container">
                <button class="attachment-btn" disabled="disabled">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-paperclip" viewBox="0 0 16 16">
                        <path d="M4.5 3a2.5 2.5 0 0 1 5 0v9a1.5 1.5 0 0 1-3 0V5a.5.5 0 0 1 1 0v7a.5.5 0 0 0 1 0V3a1.5 1.5 0 1 0-3 0v9a2.5 2.5 0 0 0 5 0V5a.5.5 0 0 1 1 0v7a3.5 3.5 0 1 1-7 0z"/>
                    </svg>
                </button>
                <input type="text" class="message-input" placeholder="Введите сообщение...">
                <button class="send-btn send-m-support">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-send" viewBox="0 0 16 16">
                        <path d="M15.854.146a.5.5 0 0 1 .11.54l-5.819 14.547a.75.75 0 0 1-1.329.124l-3.178-4.995L.643 7.184a.75.75 0 0 1 .124-1.33L15.314.037a.5.5 0 0 1 .54.11ZM6.636 10.07l2.761 4.338L14.13 2.576zm6.787-8.201L1.591 6.602l4.339 2.76z"/>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Ticket Modal -->
<div class="modal fade" id="ticketModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Создать тикет</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="ticketForm">
                    <div class="mb-3">
                        <label class="form-label">Тема</label>
                        <input type="text" id="ticketTitle" name="title" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Описание</label>
                        <textarea id="ticketDescription" name="description" class="form-control" rows="4" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Приоритет</label>
                        <select id="ticketPriority" name="priority" class="form-select">
                            <option value="low">Низкий</option>
                            <option value="medium" selected>Средний</option>
                            <option value="high">Высокий</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Отмена</button>
                <button type="submit" form="ticketForm" class="btn btn-primary">Отправить</button>
            </div>
        </div>
    </div>
</div>

<!-- Chat Modal -->
<div class="modal fade" id="chatModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title">Чат с поддержкой</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-success d-flex align-items-center mb-4">
                    <i class="bi bi-check-circle-fill me-2"></i>
                    <span>Соединение установлено. Ожидайте ответа оператора...</span>
                </div>

                <div class="chat-messages mb-4">
                    <div class="d-flex mb-3">
                        <div class="avatar me-3">
                            <div class="bg-primary rounded-circle p-2 text-white">
                                <i class="bi bi-person"></i>
                            </div>
                        </div>
                        <div class="message bg-light p-3 rounded">
                            <p class="mb-0">Здравствуйте! Какой у вас вопрос?</p>
                            <div class="text-muted small mt-1">Оператор • Только что</div>
                        </div>
                    </div>
                </div>

                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Напишите сообщение...">
                    <button class="btn btn-primary">Отправить</button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --primary: #10B981;
        --primary-dark: #059669;
        --surface-light: #FFFFFF;
        --surface-dark: #121212;
        --text-light: #1F2937;
        --text-dark: #F3F4F6;
        --bg-light: #F9FAFB;
        --bg-dark: #1E293B;
        --card-light: #FFFFFF;
        --card-dark: #1E293B;
        --border-light: #E5E7EB;
        --border-dark: #374151;
        --agent-msg-light: #F3F4F6;
        --agent-msg-dark: #334155;
        --user-msg-light: #D1FAE5;
        --user-msg-dark: #047857;
        --shadow-light: 0 4px 20px rgba(0,0,0,0.08);
        --shadow-dark: 0 4px 20px rgba(0,0,0,0.25);
    }

    .support-widget {
        position: relative;
        display: inline-block;
    }
    .support-dropdown {
        width: 300px;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border: none;
        transform: translateX(-85%) !important;
    }
    #chatWidget {
        border-radius: 1rem;
        animation: fadeInUp 0.3s ease;
    }

    @keyframes fadeInUp {
        from {
            transform: translateY(20px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
    .chat-widget {
        position: fixed;
        bottom: 80px;
        right: 30px;
        width: 300px;
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.2);
        display: none;
        flex-direction: column;
        z-index: 9999;
    }

    .chat-header {
        background-color: #28a745;
        color: white;
        padding: 10px;
        font-weight: bold;
        border-radius: 10px 10px 0 0;
    }

    .chat-body {
        padding: 10px;
        height: 150px;
        overflow-y: auto;
    }

    .chat-footer {
        display: flex;
        padding: 10px;
        border-top: 1px solid #ddd;
    }

    .chat-footer input {
        flex: 1;
        padding: 5px;
    }

    .chat-footer button {
        background-color: #28a745;
        color: white;
        border: none;
        padding: 5px 10px;
        margin-left: 5px;
    }


    .support-btn {
        cursor: pointer;
    }
  /*  .support-btn:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 20px rgba(37, 117, 252, 0.4);
    }*/
    .support-option {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 12px;
        cursor: pointer;
        transition: all 0.2s;
        border: 4px solid rgba(255, 255, 255, 0.3);
    }
    .support-option:hover {
        transform: translateY(-2px);
        border-color: rgba(255, 255, 255, 0.3);
    }
    .support-header {
        padding-bottom: 15px;
        margin-bottom: 15px;
    }
    .support-badge {
        position: absolute;
        top: -5px;
        right: -5px;
        width: 24px;
        height: 24px;
        background-color: #20c997;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        color: white;
        border: 2px solid white;
    }
    .demo-header {
        text-align: center;
        margin-bottom: 40px;
        max-width: 600px;
    }

    .demo-header h1 {
        font-size: 2.5rem;
        font-weight: 700;
        background: linear-gradient(to right, #047857, #10B981);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
        margin-bottom: 16px;
    }

    .demo-header p {
        font-size: 1.1rem;
        color: #4B5563;
        line-height: 1.6;
    }

    .theme-toggle {
        position: fixed;
        top: 20px;
        right: 20px;
        background: var(--primary);
        color: white;
        border: none;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        z-index: 1000;
        transition: all 0.3s ease;
    }

    .theme-toggle:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 15px rgba(0,0,0,0.15);
    }

    /* Виджет чата */
    .chat-widget-container {
        position: fixed;
        bottom: 30px;
        right: 30px;
        z-index: 1000;
        transition: transform 0.3s ease;
    }

    .chat-widget-container .chat-toggle {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        background: var(--primary);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: var(--shadow-light);
        cursor: pointer;
        position: relative;
        transition: all 0.3s ease;
    }

    .chat-widget-container .chat-toggle i {
        font-size: 24px;
    }

    .notification-badge {
        position: absolute;
        top: -5px;
        right: -5px;
        width: 24px;
        height: 24px;
        background: #EF4444;
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: bold;
        border: 2px solid white;
    }

    .chat-widget-container #chatWidget {
        width: 360px;
        max-height: 500px;
        border-radius: 18px;
        overflow: hidden;
        display: none;
        box-shadow: var(--shadow-light);
        background: var(--card-light);
        color: var(--text-light);
        border: 1px solid var(--border-light);
        flex-direction: column;
        position: relative;
        animation: widgetFadeIn 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }

    @keyframes widgetFadeIn {
        from { opacity: 0; transform: translateY(20px) scale(0.95); }
        to { opacity: 1; transform: translateY(0) scale(1); }
    }

    .chat-widget-container .chat-header {
        background: var(--primary);
        color: white;
        padding: 16px 20px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        cursor: move;
        position: relative;
    }

    .chat-widget-container .agent-info {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .chat-widget-container .agent-avatar {
        width: 42px;
        height: 42px;
        border-radius: 50%;
        background: linear-gradient(45deg, #8B5CF6, #EC4899);
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        color: white;
        font-size: 18px;
    }

    .chat-widget-container .agent-details {
        line-height: 1.4;
    }

    .chat-widget-container .agent-name {
        font-weight: 600;
        font-size: 16px;
    }

    .chat-widget-container .agent-status {
        font-size: 12px;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .chat-widget-container .status-indicator {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: #34D399;
    }

    .chat-widget-container .header-actions {
        display: flex;
        gap: 12px;
    }

    .chat-widget-container .header-btn {
        background: rgba(255,255,255,0.2);
        border: none;
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .chat-widget-container .header-btn:hover {
        background: rgba(255,255,255,0.3);
        transform: scale(1.1);
    }

    .chat-widget-container .chat-body {
        flex: 1;
        overflow-y: auto;
        padding: 20px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        max-height: 340px;
        background: var(--card-light);
    }

    .chat-widget-container .message {
        display: flex;
        gap: 10px;
        max-width: 85%;
        animation: messageAppear 0.3s ease;
    }

    @keyframes messageAppear {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .agent-message {
        align-self: flex-start;
    }

    .user-message {
        align-self: flex-end;
    }

    .message-avatar {
        flex-shrink: 0;
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        color: white;
        font-size: 14px;
    }

    .agent-avatar-small {
        background: linear-gradient(45deg, #8B5CF6, #EC4899);
    }

    .user-avatar-small {
        background: linear-gradient(45deg, #10B981, #3B82F6);
    }

    .message-content {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }

    .message-bubble {
        padding: 12px 16px;
        border-radius: 18px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        line-height: 1.4;
        position: relative;
    }

    .agent-bubble {
        background: var(--agent-msg-light);
        border-top-left-radius: 4px;
        color: var(--text-light);
    }

    .user-bubble {
        background: var(--user-msg-light);
        border-top-right-radius: 4px;
        color: var(--text-light);
    }

    .message-time {
        font-size: 11px;
        color: #6B7280;
        align-self: flex-end;
    }

    .typing-indicator {
        display: flex;
        align-items: center;
        gap: 6px;
        background: var(--agent-msg-light);
        padding: 10px 16px;
        border-radius: 18px;
        width: fit-content;
        border-top-left-radius: 4px;
        color: var(--text-light);
    }

    .typing-indicator span {
        width: 6px;
        height: 6px;
        background: #9CA3AF;
        border-radius: 50%;
        display: inline-block;
        animation: typing 1.4s infinite ease-in-out;
    }

    .typing-indicator span:nth-child(1) { animation-delay: 0s; }
    .typing-indicator span:nth-child(2) { animation-delay: 0.2s; }
    .typing-indicator span:nth-child(3) { animation-delay: 0.4s; }

    @keyframes typing {
        0%, 60%, 100% { transform: translateY(0); }
        30% { transform: translateY(-4px); }
    }

    .chat-footer {
        padding: 16px;
        background: var(--card-light);
        border-top: 1px solid var(--border-light);
    }

    .input-container {
        display: flex;
        gap: 10px;
        align-items: center;
    }

    .attachment-btn {
        background: transparent;
        border: none;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #6B7280;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .attachment-btn:hover {
        background: var(--agent-msg-light);
        color: var(--primary);
    }

    .message-input {
        flex: 1;
        padding: 12px 16px;
        border-radius: 24px;
        border: 1px solid var(--border-light);
        background: var(--card-light);
        color: var(--text-light);
        outline: none;
        transition: all 0.3s ease;
        font-size: 14px;
    }

    .message-input:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.2);
    }

    .send-btn {
        background: var(--primary);
        border: none;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .send-btn:hover {
        background: var(--primary-dark);
        transform: scale(1.05);
    }

    /* Темная тема */
    body.dark-theme {
        background: linear-gradient(135deg, #0f172a, #1e293b);
    }

    body.dark-theme .demo-header h1 {
        background: linear-gradient(to right, #34D399, #10B981);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
    }

    body.dark-theme .demo-header p {
        color: #CBD5E1;
    }

    body.dark-theme #chatWidget {
        background: var(--card-dark);
        color: var(--text-dark);
        border-color: var(--border-dark);
        box-shadow: var(--shadow-dark);
    }

    body.dark-theme .chat-body {
        background: var(--card-dark);
    }

    body.dark-theme .agent-bubble {
        background: var(--agent-msg-dark);
        color: var(--text-dark);
    }

    body.dark-theme .user-bubble {
        background: var(--user-msg-dark);
        color: white;
    }

    body.dark-theme .message-time {
        color: #9CA3AF;
    }

    body.dark-theme .chat-footer {
        background: var(--card-dark);
        border-color: var(--border-dark);
    }

    body.dark-theme .message-input {
        background: var(--bg-dark);
        border-color: var(--border-dark);
        color: var(--text-dark);
    }

    body.dark-theme .typing-indicator {
        background: var(--agent-msg-dark);
        color: var(--text-dark);
    }

    body.dark-theme .attachment-btn:hover {
        background: var(--agent-msg-dark);
    }

    /* Адаптивность */
    @media (max-width: 500px) {
        #chatWidget {
            width: 100%;
            max-width: 100%;
            height: 100%;
            max-height: 100%;
            border-radius: 0;
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
        }

        .chat-widget-container {
            bottom: 20px;
            right: 20px;
        }

        .demo-header h1 {
            font-size: 2rem;
        }
    }
</style>




<script src="{$theme}/assets/ws/support.js"></script>