<link href="https://cdn.datatables.net/v/dt/jq-3.7.0/jszip-3.10.1/dt-2.1.8/af-2.7.0/b-3.2.0/b-colvis-3.2.0/b-html5-3.2.0/b-print-3.2.0/cr-2.0.4/datatables.min.css" rel="stylesheet">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link href="system/assets/css/dataTables.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="system/assets/bundles/dataTables.bundle.js"></script>

<div class="container p-0">
    <h1 class="mt-2">{$tableTitle}</h1>
    <div></div>
    <table id="{if isset($id)}{$id}-datatable{else}datatable{/if}" class="ui celled table modern-table" style="width:100%">
        <thead>
        <tr>
            {foreach $theads as $key => $item}
                <th>{$item}</th>
            {/foreach}
        </tr>
        </thead>
    </table>
</div>

<script>
    $(document).ready(function() {
        var jsonData = {$data|json_encode};

        let columns = [];
        let theads = {$theads|json_encode};
        for (let i = 0; i < theads.length; i++) {
            columns.push({
                data: theads[i],
            });
        }

        let table = new DataTable('#{if isset($id)}{$id}-datatable{else}datatable{/if}', {
            responsive: true,
            data: jsonData,
            order: [[0, 'desc']],
            columns: columns,
            language: {
                emptyTable: "{$lang.datatable.emptyTable}",
                info: "{$lang.datatable.info}",
                infoEmpty: "{$lang.datatable.infoEmpty}",
                lengthMenu: "{$lang.datatable.lengthMenu}",
                search: "{$lang.datatable.search}",
                paginate: {
                    first: "{$lang.datatable.first}",
                    last: "{$lang.datatable.last}",
                    next: "{$lang.datatable.next}",
                    previous: "{$lang.datatable.previous}"
                }
            }
        });

        // Восстанавливаем количество записей на странице
        var savedEntries = localStorage.getItem('datatable_entries');
        if (savedEntries) {
            table.page.len(savedEntries).draw();
        }

        // Восстанавливаем сохранённую страницу
        var savedPage = localStorage.getItem('datatable_page');
        if (savedPage) {
            table.page(parseInt(savedPage)).draw('page');
        }

        // Сохраняем выбранное количество записей на странице
        $('.dataTables_length select').on('change', function() {
            var entries = $(this).val();
            localStorage.setItem('datatable_entries', entries);
        });

        // Сохраняем текущую страницу при изменении
        table.on('draw', function() {
            var pageInfo = table.page.info();
            localStorage.setItem('datatable_page', pageInfo.page);
        });

        // Стилизация поля поиска
        $(".dataTables_filter input").addClass("form-control").css({
            "width": "auto",
            "display": "inline-block"
        });
    });

</script>

<style>
    tr.child td.child {
        border-radius: 8px; /* Скругленные углы */
        padding: 10px;
    }

    tr.child .dtr-details {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    tr.child .dtr-details li {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    tr.child .dtr-title {
        font-weight: bold;
    }

    tr.child .dtr-data {
        color: #666;
    }

    tr.child .btn-group {
        display: flex;
        gap: 6px;
    }

    tr.child .btn-group form {
        margin: 0;
    }

    tr.child .btn-group button {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        border-radius: 6px;
        transition: all 0.2s ease-in-out;
        cursor: pointer;
        border: none;
    }

    tr.child .btn-group button i {
        font-size: 16px;
    }

    tr.child button[name="deluser"] {
        background: #dc3545;
        color: white;
    }

    tr.child button[name="deluser"]:hover {
        background: #c82333;
    }

    tr.child button[name="edituser"] {
        color: white;
    }

    tr.child button[name="edituser"]:hover {
        background: #0056b3;
    }

    .container {
        max-width: 1620px;
    }

    .modern-table {
        border-collapse: separate;
        border-spacing: 0 15px;
    }

    .modern-table thead th {
        text-align: center;
        padding: 10px;
    }

    .modern-table tbody tr {
        background-color: #f9f9f9;
        transition: all 0.3s ease-in-out;
    }

    .modern-table tbody tr:hover {
        background-color: #f1f1f1;
    }

    .modern-table tbody td {
        padding: 10px;
        text-align: center;
        border-top: 1px solid #ddd;
        transition: background-color 0.3s ease, transform 0.3s ease;
    }

    .modern-table tbody tr:hover {
        cursor: pointer;
        background-color: #e0f7fa;
        transform: scale(1.01);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .modern-table .search-label {
        margin-right: 10px;
        font-weight: bold;
    }

    .modern-table .form-control {
        border-radius: 5px;
        padding: 5px 10px;
    }
</style>
