<!DOCTYPE html>
<html lang="en">
  {include file="./blocks/head.tpl"}
  <body>
    <!-- Preloader -->
    <div class="preloader preloader-dark">
      <div class="lds-ellipsis">
        <div></div>
        <div></div>
        <div></div>
        <div></div>
      </div>
    </div>
    <!-- Preloader End -->
    <!-- Document Wrapper -->
    <div id="main-wrapper">
      <div class="container-fluid px-0">
        <div class="row g-0 min-vh-100">
          <!-- Intro -->
          <div class="col-lg-7 d-flex flex-column bg-dark">
            <!-- Domain Details -->
             {include file="./blocks/language.tpl"}
            <div class="container py-5 px-4 px-lg-5 my-auto">
              <div class="row text-center">
                <div class="col-12 mx-auto mb-4">
                  <!-- Logo -->
                   {include file="./blocks/logo.tpl"}
                  <!-- Logo End -->
                </div>
				<div class="col-12 mx-auto">
					<h1 class="text-6 bg-success d-inline-block fw-700 rounded px-3 py-2 mb-4">
						{$lang.main.best_solid_principles}
					</h1>
					<h2 class="text-9 text-white fw-600 mb-4">
						{$lang.main.new_generation_experience}
					</h2>
				</div>

				<div class="col-md-9 col-xl-8 mx-auto">
					<p class="text-5 text-light mb-3">
						{$lang.main.preparing_exceptional}
					</p>
				</div>
              </div>
            </div>
            <div class="container pb-2 px-3">
              <div class="row text-white">
                <div class="col-sm-6 col-md-4 d-flex align-items-center justify-content-center justify-content-md-start">
                  <span class="me-2">
                    <i class="fas fa-info-circle"></i>
                  </span>
                  <a class="text-white" data-bs-toggle="modal" data-bs-target="#about" href="#">{$lang.main.about_us}</a>
                </div>
                <div class="col-sm-6 col-md-4 d-flex align-items-center justify-content-center mt-2 mt-sm-0">
                  <span class="me-2">
                    <i class="fas fa-phone-alt"></i>
                  </span> +1 (929) 899-47-46
                </div>
                <div class="col-md-4 d-flex align-items-center justify-content-center justify-content-md-end mt-2 mt-md-0">
                  <ul class="social-icons social-icons-light">
                    <li class="social-icons-facebook">
                      <a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook">
                        <i class="fab fa-facebook"></i>
                      </a>
                    </li>
                    <li class="social-icons-instagram">
                      <a data-bs-toggle="tooltip" href="http://www.instagram.com/" target="_blank" title="Instagram">
                        <i class="fab fa-instagram"></i>
                      </a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <!-- Intro End -->
          <!-- Contact Us -->
          <div class="col-lg-5 d-flex flex-column text-center bg-dark-2">
            <div class="container my-auto py-5 pt-lg-4 pb-lg-2">
              <div class="row mx-0">
				
				<!-- <div class="col-12 p-4 blur">
					{*{include file="./submit_feedback.tpl"}*}
				</div> -->
                <div class="col-11 col-lg-10 mx-auto">
                  <h3 class="mb-3 text-white fw-600">{$lang.main.contact_us}</h3>
                  <p class="text-white-50 mb-4">{$lang.main.contact_text}</p>
                  <!-- Contact Form -->
                  <form id="contact-form" class="form-dark" action="" method="post">
                    <div class="mb-3">
                      <input id="name" name="name" type="text" class="form-control border-2" placeholder="{$lang.main.enter_name}" required="">
                    </div>
                    <div class="mb-3">
                      <input id="email" name="email" type="email" class="form-control border-2" placeholder="{$lang.main.enter_email}" required="">
                    </div>
                    <div class="mb-3">
                      <textarea id="form-message" name="form-message" class="form-control border-2" rows="2" placeholder="{$lang.main.enter_query}" required=""></textarea>
                    </div>
                    <div class="d-grid mt-4">
                      <button id="submit-btn" class="btn btn-success" type="submit">{$lang.main.send_message}</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
            <!-- Footer -->
             {include file="./blocks/footer.tpl"}
          </div>
          <!-- Contact Us End -->
        </div>
      </div>
    </div>
    <!-- Document Wrapper End -->
    <!-- About Popup -->
    <div id="about" class="modal fade" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title fw-600 text-7 mx-auto">About Us</h5>
            <button type="button" class="btn-close ms-0" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body p-4">
            <p class="lead text-center">Lorem ipsum dolor sit amet consectetur adipisicing elit. Veritatis commodi earum totam voluptatem et cupiditate asperiores consequatur doloribus eius magnam, possimus libero officiis reprehenderit odit nulla eaque voluptate soluta officia?</p>
          </div>
        </div>
      </div>
    </div>
    {include file="./blocks/bodyendscripts.tpl"}
  </body>
</html>