{if isset($events_latest_entries) && $events_latest_entries}
    <div class="row mt-1">
        <div class="col-12">
            <h4 class="mb-2 text-center">Последние мероприятия</h4>
            <!-- Вывод последних новостей -->
            <div class="swiper-container" id="latestEventsSwiper">
                <div class="swiper-wrapper">
                    {foreach $latestEvents as $events}
                        <div class="swiper-slide">
                            <div class="row">
                                <div class="col-5">
                                    <a href="/events/{$events.alt_name}?lang={$events.language}">
                                        <span class="position-absolute float-start badge rounded-pill bg-dark m-1">{$events.date|date_format:"%d-%m-%Y"}</span>
                                        <img class="img-responsive max-wpx-250" src="../{$events.image}" alt="">
                                    </a>
                                </div>
                                <div class="col-7">
                                    <a href="/events/{$events.alt_name}?lang={$events.language}"><h6 class="text-primary">{$events.title|truncate:55:"..."}</h6></a>
                                    <p class="fs-7 mb-0">{$events.short_desc|truncate:110:"..."}</p>
                                    <div class="countdown d-flex justify-content-center align-items-center mt-3 pt-3 border-top" data-end-time='{$events.end_date|date_format:"%m/%d/%Y - %H:%M:%S"}'>
                                        <span class="days" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Days">00</span> :
                                        <span class="hours" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Hours">00</span> :
                                        <span class="minutes" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Minutes">00</span> :
                                        <span class="seconds" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Seconds">00</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    {/foreach}
                </div>
                <div class="manage-buttons mb-5">
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>
    </div>
{/if}