<div class="row">
    {foreach $eventsList as $event}
        {assign var='category' value=','|explode:$event.category}
        <div class="col-12 col-lg-6 mb-5">
            <div class="card" style="background: transparent; border: none;">
                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-5">
                            <a href="/events/{$event.alt_name}?lang={$event.language}">
                                <span class="position-absolute float-start badge rounded-pill bg-dark m-1">{$event.converted_price} {$currentCurrency}</span>
                                <img class="img-responsive" src="../{$event.image}" alt="">
                            </a>
                        </div>
                        <div class="col-7 shortdesc">
                            <span class="float-end" title="Количество подписанных участников {$event.participants} из {$event.capacity}">{$event.participants} / {$event.capacity}</span>
                            <a href="/events/{$event.alt_name}?lang={$event.language}">
                                <h6 class="text-primary mb-2">{$event.title|truncate:55:"..."}</h6>
                            </a>
                            {$event.short_desc|truncate:110:"..."}
                            <div class="countdown d-flex justify-content-center align-items-center mt-3 pt-3 border-top" data-end-time='{$event.end_date|date_format:"%m/%d/%Y - %H:%M:%S"}'>
                                <span class="days" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Days">00</span> :
                                <span class="hours" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Hours">00</span> :
                                <span class="minutes" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Minutes">00</span> :
                                <span class="seconds" data-bs-popup="popover" data-bs-trigger="hover" data-bs-placement="top" data-bs-content="Seconds">00</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    {/foreach}
</div>
{include file="../../navigation.tpl"}