<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="card border-0">
    <div class="card-header bg-card" style="background-image: url('{$userData.bg_image}') !important; background-size: cover !important;">
        <div class="d-flex align-items-md-start align-items-center flex-column flex-md-row w-100">
            <div class="m-3">
                <img src="{$userData.avatar}" class="rounded-4" alt="">
            </div>
            <div class="ms-md-4 mt-md-0" style="color: var(--theme-color1)">

                <h4 class="mt-3 mb-1" id="view_name">{$userData.name}</h4>
                <p id="view_email">{$userData.email}</p>
                <span id="view_bio" class="text-primary">{$userData.bio} 🚀</span>
            </div>
        </div>
        <div class="float-end">
{*
            <button data-bs-toggle="modal" data-bs-target="#editProfileModal" id="editProfile" class="btn btn-sm btn-primary">Edit Profile</button>
*}
            <button class="btn btn-sm btn-dark" onclick="window.location.href = 'pm&uid={$userData.id}'">Message</button>
        </div>
    </div>
</div>
<div class="modal fade" id="editProfileModal" tabindex="-1" aria-labelledby="editProfileModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editProfileModalLabel">Edit Profile</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editProfileForm">
                    <input type="hidden" id="user_id" name="user_id" value="{$userData.id}" required>

                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" value="{$userData.email}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="group" class="form-label">Group</label>
                            <input type="number" class="form-control" id="group" name="group" value="{$userData.group}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{$userData.name}" required>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="age" class="form-label">Age</label>
                            <input type="number" class="form-control" id="age" name="age" value="{$userData.age}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="gender" class="form-label">Gender</label>
                            <select class="form-select" id="gender" name="gender" required>
                                <option value="Male">Male</option>
                                <option value="Female">Female</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="text" class="form-control" id="phone" name="phone" value="{$userData.phone}" required>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="city" class="form-label">City</label>
                            <input type="text" class="form-control" id="city" name="city" value="{$userData.city}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="balance" class="form-label">Balance</label>
                            <input type="number" step="0.01" class="form-control" id="balance" name="balance" value="{$userData.balance}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="avatar" class="form-label">Avatar</label>
                            <input type="text" class="form-control" id="avatar" name="avatar" value="{$userData.avatar}" required>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="bg_image" class="form-label">Background Image</label>
                            <input type="text" class="form-control" id="bg_image" name="bg_image" value="{$userData.bg_image}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="bio" class="form-label">Bio</label>
                            <textarea class="form-control" id="bio" name="bio" rows="1">{$userData.bio}</textarea>
                        </div>
                        <div class="col-md-4">
                            <label for="pay_methods" class="form-label">Payment Methods</label>
                            <input type="text" class="form-control" id="pay_methods" name="pay_methods" value="{$userData.pay_methods}">
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="banned" class="form-label">Banned</label>
                            <select class="form-select" id="banned" name="banned" required>
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="allowpm" class="form-label">Allow Private Messages</label>
                            <select class="form-select" id="allowpm" name="allowpm" required>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="allpm" class="form-label">Receive All Private Messages</label>
                            <select class="form-select" id="allpm" name="allpm" required>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="pmunread" class="form-label">Unread Private Messages</label>
                        <input type="number" class="form-control" id="pmunread" name="pmunread">
                    </div>
                    <button type="submit" id="save-user" class="btn btn-primary w-100">Save Changes</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div id="loadingOverlay" class="loading-overlay">
    <div class="spinner"></div>
</div>
<div id="notification-container" class="notification-container"></div>
<style>
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .spinner {
        border: 4px solid rgba(255, 255, 255, 0.3);
        border-top: 4px solid #fff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .notification-container {
        position: fixed;
        top: 10px;
        right: 100px; /* Смещаем контейнер вправо */
        z-index: 1050;
        width: 300px; /* Ширина уведомлений */
    }

   /* .notification {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px 15px;
        margin-bottom: 10px;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        animation: fadeIn 0.3s ease;
        color: #fff;
    }*/

    .notification .close-btn {
        background: none;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }

    .notification.error {
        background-color: #e6231e; /* Цвет для ошибок */
    }

    .notification.success {
        background-color: #28a745; /* Цвет для успеха */
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateX(10%);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translateX(0);
        }
        to {
            opacity: 0;
            transform: translateX(10%);
        }
    }

</style>
<script>
    $('#editProfileForm').on('submit', function(event) {
        event.preventDefault();

        var formData = $(this).serialize(); // Сериализуем данные формы

        $.ajax({
            url: 'engine/ajax/lib/user/update_user.php',
            type: 'POST',
            dataType: 'json',
            data: formData,
            success: function (response) {
                if (response.success) {
                    showNotification("Изменения сохранены", "success", 10000)
                    $("#editProfileModal").modal("hide");
                    $("#view_name").html(response.data.name);
                    $("#view_email").html(response.data.email);
                    $("#view_bio").html(response.data.bio);
                }
            },
            error: function (xhr, status, error) {
                showNotification("Ошибка при обновлении данных пользователя", "error", 10000)
                return;
            }
        });
    });

    function showNotification(message, type, duration) {
        duration = 10000;//(typeof duration === 'undefined') duration = 5000; // Значение по умолчанию
        if (typeof type === 'undefined') type = 'success'; // Значение по умолчанию

        var container = document.getElementById('notification-container');

        // Создаем элемент уведомления
        var notification = document.createElement('div');
        notification.className = 'notification ' + type; // Используем конкатенацию вместо шаблонных строк
        notification.innerHTML =
            '<span>' + message + '</span>' +
            '<button class="close-btn" onclick="this.parentElement.remove()">×</button>';

        container.appendChild(notification);

        // Удаляем уведомление через заданное время
        setTimeout(function () {
            notification.style.animation = 'fadeOut 0.3s ease';
            notification.addEventListener('animationend', function () {
                notification.remove();
            });
        }, duration);
    }
</script>
{*

{if $access.update}
    <form method="post" action="">
        <label for="new_name">New Name:</label>
        <input class="form-control" type="text" id="new_name" name="new_name" value="{$name}" required>
        <br>
        <label for="new_bio">New Bio:</label>
        <textarea class="form-control" id="new_bio" name="new_bio" required>{$bio}</textarea>
        <br>
        <button type="submit" class="btn btn-primary w-100">Save</button>
    </form>
{/if}*}
