<div class="container mt-4">
    <div class="card p-3">
        {if !$widgetData.disable_title}
            <h2 class="h4">{$widgetData.name}</h2>
        {/if}

        <form method="post" class="mt-3">
            {if $widgetData.price > 0}
                <div class="alert alert-success d-flex align-items-center">
                    <span>Сумма: <strong>{$widgetData.price|number_format:2}</strong> ₽</span>
                </div>
            {/if}

            {if $widgetData.super_donater_sum && $widgetData.price <= 0}
                <div class="alert alert-warning">🎖️ Супер-донатеры от {$widgetData.super_donater_sum} {$currency}</div>
            {/if}

            {if !$widgetData.disable_sum_input }
                <input type="number" name="amount" class="form-control" placeholder="Введите сумму" min="1" step="0.01" required>
            {else}
                <input type="hidden" name="amount" value="{$widgetData.price}">
            {/if}

            <button type="button" class="btn btn-success w-100 mt-3" onclick='window.location.href = "{$widgetData.handleUrl}"'>
                {$widgetData.btn_text}
            </button>

            {if $widgetData.pay_with_redirect}
                <div class="text-muted text-center mt-2">
                    🔒 Безопасные платежи через защищенное соединение
                </div>
            {/if}
        </form>
    </div>
</div>