   <div class="subscription-card">
        <div class="badge">Экономия 20%</div>
        <div class="header">
            <h1 class="title">{$widgetData.name}</h1>
            <div class="price">{$widgetData.price} {$currency}<span style="font-size: 20px">/год</span></div>
        </div>
        <ul class="features">
            <li>Полный доступ ко всем функциям</li>
            <li>Премиум-поддержка 24/7</li>
            <li>До 5 устройств одновременно</li>
            <li>Эксклюзивный контент</li>
        </ul>
        <button class="cta-button" onclick="window.location.href = '?payment&price={$widgetData.price}&currency={$currency}&action=redirect-payment&widget={$widgetData.id}'">{$widgetData.btn_text}</button>
        <p class="note">Отменить можно в любой момент</p>
    </div>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', sans-serif;
        }

        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .subscription-card {
            width: 400px;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
            position: relative;
            overflow: hidden;
            transition: transform 0.3s ease;
        }

        .subscription-card:hover {
            transform: translateY(-5px);
        }

        .badge {
            position: absolute;
            top: 20px;
            right: -30px;
            background: #4CAF50;
            color: white;
            padding: 8px 40px;
            transform: rotate(45deg);
            font-size: 14px;
            font-weight: bold;
        }

        .header {
            margin-bottom: 30px;
        }

        .title {
            color: #2d3436;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }

        .price {
            background: linear-gradient(45deg, #6c5ce7, #a363d9);
            -webkit-background-clip: text;
            color: transparent;
            font-size: 48px;
            font-weight: 800;
            margin: 20px 0;
        }

        .features {
            list-style: none;
            margin: 25px 0;
        }

        .features li {
            display: flex;
            align-items: center;
            margin: 15px 0;
            color: #636e72;
        }

        .features li::before {
            content: '✓';
            color: #4CAF50;
            margin-right: 12px;
            font-weight: bold;
        }

        .cta-button {
            width: 100%;
            padding: 18px;
            border: none;
            background: linear-gradient(45deg, #6c5ce7, #a363d9);
            font-size: 16px;
            font-weight: 600;
            border-radius: 12px;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 15px rgba(108,92,231,0.3);
        }

        .note {
            text-align: center;
            color: #636e72;
            font-size: 12px;
            margin-top: 20px;
        }
    </style>